/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt256Value;

public abstract class BaseUInt256Value<T extends UInt256Value<T>>
implements UInt256Value<T> {
    private final UInt256 value;
    private final Function<UInt256, T> ctor;

    protected BaseUInt256Value(UInt256 value, Function<UInt256, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = value;
        this.ctor = ctor;
    }

    protected BaseUInt256Value(long value, Function<UInt256, T> ctor) {
        Objects.requireNonNull(ctor);
        this.value = UInt256.valueOf(value);
        this.ctor = ctor;
    }

    protected BaseUInt256Value(BigInteger value, Function<UInt256, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = UInt256.valueOf(value);
        this.ctor = ctor;
    }

    public T copy() {
        return (T)((UInt256Value)this.ctor.apply(this.value));
    }

    protected T zero() {
        return (T)((UInt256Value)this.ctor.apply(UInt256.ZERO));
    }

    @Override
    public T max() {
        return (T)((UInt256Value)this.ctor.apply(UInt256.MAX_VALUE));
    }

    @Override
    public T add(T value) {
        return this.add(value.toUInt256());
    }

    @Override
    public T add(UInt256 value) {
        if (value.isZero()) {
            return (T)this.copy();
        }
        return (T)((UInt256Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T add(long value) {
        if (value == 0L) {
            return (T)this.copy();
        }
        return (T)((UInt256Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T addMod(T value, UInt256 modulus) {
        return this.addMod(value.toUInt256(), modulus);
    }

    @Override
    public T addMod(UInt256 value, UInt256 modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, UInt256 modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, long modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T subtract(T value) {
        return this.subtract(value.toUInt256());
    }

    @Override
    public T subtract(UInt256 value) {
        if (value.isZero()) {
            return (T)this.copy();
        }
        return (T)((UInt256Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T subtract(long value) {
        if (value == 0L) {
            return (T)this.copy();
        }
        return (T)((UInt256Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T multiply(T value) {
        return this.multiply(value.toUInt256());
    }

    @Override
    public T multiply(UInt256 value) {
        if (this.isZero() || value.isZero()) {
            return this.zero();
        }
        if (value.equals(UInt256.ONE)) {
            return (T)this.copy();
        }
        if (this.value.equals(UInt256.ONE)) {
            return (T)((UInt256Value)this.ctor.apply(value));
        }
        return (T)((UInt256Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiply(long value) {
        if (value == 0L || this.isZero()) {
            return this.zero();
        }
        if (value == 1L) {
            return (T)this.copy();
        }
        if (this.value.equals(UInt256.ONE)) {
            return (T)((UInt256Value)this.ctor.apply(UInt256.valueOf(value)));
        }
        return (T)((UInt256Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiplyMod(T value, UInt256 modulus) {
        return this.multiplyMod(value.toUInt256(), modulus);
    }

    @Override
    public T multiplyMod(UInt256 value, UInt256 modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(long value, UInt256 modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(long value, long modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T divide(T value) {
        return this.divide(value.toUInt256());
    }

    @Override
    public T divide(UInt256 value) {
        return (T)((UInt256Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T divide(long value) {
        return (T)((UInt256Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T divideCeil(T value) {
        return this.divideCeil(value.toUInt256());
    }

    @Override
    public T divideCeil(UInt256 value) {
        return (T)((UInt256Value)this.ctor.apply(this.value.divideCeil(value)));
    }

    @Override
    public T divideCeil(long value) {
        return (T)((UInt256Value)this.ctor.apply(this.value.divideCeil(value)));
    }

    @Override
    public T pow(UInt256 exponent) {
        return (T)((UInt256Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T pow(long exponent) {
        return (T)((UInt256Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T mod(UInt256 modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public T mod(long modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public T mod0(UInt256 modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.mod0(modulus)));
    }

    @Override
    public T mod0(long modulus) {
        return (T)((UInt256Value)this.ctor.apply(this.value.mod0(modulus)));
    }

    public int compareTo(UInt256 other) {
        return this.value.compareTo((Bytes)other);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UInt256Value)) {
            return false;
        }
        UInt256Value other = (UInt256Value)obj;
        return this.value.equals(other.toUInt256());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public UInt256 toUInt256() {
        return this.value;
    }

    @Override
    public Bytes32 toBytes() {
        return this.value;
    }

    @Override
    public Bytes toMinimalBytes() {
        return this.value.toMinimalBytes();
    }

    public byte get(int i) {
        return this.value.get(i);
    }

    public Bytes slice(int i, int length) {
        return this.value.slice(i, length);
    }

    public MutableBytes32 mutableCopy() {
        return MutableBytes32.wrap((byte[])this.value.toArrayUnsafe());
    }

    @Override
    public long toLong(ByteOrder order) {
        return this.value.toLong(order);
    }
}

