/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.gas;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.app.hapi.fees.pricing.AssetsLoader;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hederahashgraph.api.proto.java.SubType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CanonicalDispatchPrices {
    private final Map<DispatchType, Long> pricesMap = new EnumMap<DispatchType, Long>(DispatchType.class);
    public static final BigDecimal USD_TO_TINYCENTS = BigDecimal.valueOf(10000000000L);

    @Inject
    public CanonicalDispatchPrices(@NonNull AssetsLoader assetsLoader) {
        Objects.requireNonNull(assetsLoader);
        try {
            Map<HederaFunctionality, Map> canonicalPrices = assetsLoader.loadCanonicalPrices().entrySet().stream().collect(Collectors.toMap(entry -> CommonPbjConverters.toPbj((com.hederahashgraph.api.proto.java.HederaFunctionality)((com.hederahashgraph.api.proto.java.HederaFunctionality)entry.getKey())), entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(subEntry -> CommonPbjConverters.toPbj((SubType)((SubType)subEntry.getKey())), subEntry -> ((BigDecimal)subEntry.getValue()).multiply(USD_TO_TINYCENTS).longValue()))));
            Arrays.stream((DispatchType[])DispatchType.class.getEnumConstants()).map(dispatchType -> new AbstractMap.SimpleImmutableEntry<DispatchType, Long>((DispatchType)((Object)dispatchType), (Long)canonicalPrices.getOrDefault(dispatchType.functionality(), Collections.emptyMap()).get(dispatchType.subtype()))).filter(entry -> entry.getValue() != null).forEach(entry -> this.pricesMap.put((DispatchType)((Object)((Object)entry.getKey())), (Long)entry.getValue()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long canonicalPriceInTinycents(@NonNull DispatchType dispatchType) {
        return Objects.requireNonNull(this.pricesMap.get((Object)dispatchType));
    }
}

