/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.hapi.streams.SidecarType;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.operations.DelegatingOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.utils.OpUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.SStoreOperation;

public class CustomSStoreOperation
extends DelegatingOperation {
    private final FeatureFlags featureFlags;

    public CustomSStoreOperation(@NonNull FeatureFlags featureFlags, @NonNull SStoreOperation delegate) {
        super((Operation)delegate);
        this.featureFlags = featureFlags;
    }

    @Override
    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        Objects.requireNonNull(evm);
        Objects.requireNonNull(frame);
        Bytes key = frame.getStackItem(0);
        Operation.OperationResult result = super.execute(frame, evm);
        if (result.getHaltReason() == null && this.featureFlags.isSidecarEnabled(frame, SidecarType.CONTRACT_STATE_CHANGE)) {
            Account account = frame.getWorldUpdater().get(frame.getRecipientAddress());
            UInt256 slotKey = UInt256.fromBytes((Bytes)key);
            UInt256 slotValue = account.getOriginalStorageValue(slotKey);
            OpUtils.maybeTrackReadIn(frame, slotKey, slotValue);
        }
        return result;
    }
}

