/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.node.app.service.contract.impl.exec.scope.ActiveContractVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategies;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class DefaultVerificationStrategies
implements VerificationStrategies {
    @Override
    public VerificationStrategy activatingOnlyContractKeysFor(@NonNull Address sender, boolean requiresDelegatePermission, @NonNull HederaNativeOperations nativeOperations) {
        long contractNum = ConversionUtils.maybeMissingNumberOf(sender, nativeOperations);
        if (contractNum == -1L) {
            throw new IllegalArgumentException("Cannot verify against missing contract " + String.valueOf(sender));
        }
        return new ActiveContractVerificationStrategy(nativeOperations.entityIdFactory().newContractId(contractNum), ConversionUtils.tuweniToPbjBytes((Bytes)sender), requiresDelegatePermission, ActiveContractVerificationStrategy.UseTopLevelSigs.NO);
    }
}

