/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.scope.SystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.NoopFeeCharging;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;

@TransactionScope
public class HandleSystemContractOperations
implements SystemContractOperations {
    private final HandleContext context;
    @Nullable
    private final Key maybeEthSenderKey;

    @Inject
    public HandleSystemContractOperations(@NonNull HandleContext context, @Nullable Key maybeEthSenderKey) {
        this.context = Objects.requireNonNull(context);
        this.maybeEthSenderKey = maybeEthSenderKey;
    }

    @Override
    @NonNull
    public Predicate<Key> primitiveSignatureTestWith(@NonNull VerificationStrategy strategy) {
        Objects.requireNonNull(strategy);
        return strategy.asPrimitiveSignatureTestIn(this.context, this.maybeEthSenderKey);
    }

    @Override
    @NonNull
    public Predicate<Key> signatureTestWith(@NonNull VerificationStrategy strategy) {
        Objects.requireNonNull(strategy);
        return strategy.asSignatureTestIn(this.context, this.maybeEthSenderKey);
    }

    @Override
    @NonNull
    public <T extends StreamBuilder> T dispatch(@NonNull TransactionBody syntheticBody, @NonNull VerificationStrategy strategy, @NonNull AccountID syntheticPayerId, @NonNull Class<T> streamBuilderType, @NonNull Set<Key> authorizingKeys, @NonNull DispatchOptions.UsePresetTxnId usePresetTxnId) {
        Objects.requireNonNull(syntheticBody);
        Objects.requireNonNull(strategy);
        Objects.requireNonNull(syntheticPayerId);
        Objects.requireNonNull(streamBuilderType);
        Objects.requireNonNull(authorizingKeys);
        Objects.requireNonNull(usePresetTxnId);
        return (T)this.context.dispatch(DispatchOptions.subDispatch((AccountID)syntheticPayerId, (TransactionBody)syntheticBody, this.primitiveSignatureTestWith(strategy), authorizingKeys, streamBuilderType, (DispatchOptions.StakingRewards)DispatchOptions.StakingRewards.OFF, (DispatchOptions.UsePresetTxnId)usePresetTxnId, (FeeCharging)NoopFeeCharging.NOOP_FEE_CHARGING, (DispatchOptions.PropagateFeeChargingStrategy)DispatchOptions.PropagateFeeChargingStrategy.YES));
    }

    @Override
    public ContractCallStreamBuilder externalizePreemptedDispatch(@NonNull TransactionBody syntheticBody, @NonNull ResponseCodeEnum preemptingStatus, @NonNull HederaFunctionality functionality) {
        Objects.requireNonNull(syntheticBody);
        Objects.requireNonNull(preemptingStatus);
        Objects.requireNonNull(functionality);
        return ((ContractCallStreamBuilder)this.context.savepointStack().addChildRecordBuilder(ContractCallStreamBuilder.class, functionality)).signedTx(StreamBuilder.signedTxWith((TransactionBody)syntheticBody)).status(preemptingStatus);
    }

    @Override
    public void externalizeResult(@Deprecated @NonNull ContractFunctionResult result, @NonNull ResponseCodeEnum responseStatus, @NonNull SignedTransaction signedTx, @NonNull EvmTransactionResult txResult) {
        Objects.requireNonNull(signedTx);
        Objects.requireNonNull(result);
        Objects.requireNonNull(responseStatus);
        Objects.requireNonNull(txResult);
        ((ContractCallStreamBuilder)this.context.savepointStack().addChildRecordBuilder(ContractCallStreamBuilder.class, HederaFunctionality.CONTRACT_CALL)).signedTx(signedTx).status(responseStatus).contractCallResult(result).evmCallTransactionResult(txResult);
    }

    @Override
    public SignedTransaction syntheticSignedTxForNativeCall(@NonNull Bytes input, @NonNull ContractID contractID, boolean isViewCall) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(contractID);
        com.hedera.pbj.runtime.io.buffer.Bytes functionParameters = ConversionUtils.tuweniToPbjBytes(input);
        ContractCallTransactionBody.Builder contractCallBodyBuilder = ContractCallTransactionBody.newBuilder().contractID(contractID).functionParameters(functionParameters);
        if (isViewCall) {
            contractCallBodyBuilder.gas(1L);
        }
        TransactionBody transactionBody = TransactionBody.newBuilder().transactionID(TransactionID.DEFAULT).contractCall(contractCallBodyBuilder.build()).build();
        return StreamBuilder.signedTxWith((TransactionBody)transactionBody);
    }

    @Override
    @NonNull
    public ExchangeRate currentExchangeRate() {
        return this.context.exchangeRateInfo().activeRate(this.context.consensusNow());
    }

    @Override
    @Nullable
    public Key maybeEthSenderKey() {
        return this.maybeEthSenderKey;
    }
}

