/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.common;

import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAttemptOptions;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public abstract class AbstractCallAttempt<T extends AbstractCallAttempt<T>> {
    protected final CallAttemptOptions<T> options;
    protected final AccountID senderId;
    protected final Bytes input;
    protected final byte[] selector;
    @Nullable
    protected final Address redirectAddress;

    public AbstractCallAttempt(@NonNull Bytes input, @NonNull CallAttemptOptions<T> options, @NonNull Function redirectFunction) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(redirectFunction);
        this.options = Objects.requireNonNull(options);
        this.senderId = options.addressIdConverter().convertSender(options.senderAddress());
        if (this.isRedirectSelector(redirectFunction.selector(), input.toArrayUnsafe())) {
            Tuple abiCall = null;
            try {
                abiCall = redirectFunction.decodeCall(input.toArrayUnsafe());
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException | BufferUnderflowException runtimeException) {
                // empty catch block
            }
            if (abiCall != null) {
                this.redirectAddress = Address.fromHexString((String)abiCall.get(0).toString());
                this.input = Bytes.wrap((byte[])((byte[])abiCall.get(1)));
            } else {
                this.redirectAddress = Address.wrap((Bytes)input.slice(4, 20));
                this.input = input.slice(24);
            }
        } else {
            this.redirectAddress = null;
            this.input = input;
        }
        this.selector = this.input.slice(0, 4).toArrayUnsafe();
    }

    protected abstract SystemContractMethod.SystemContract systemContractKind();

    protected abstract T self();

    @NonNull
    public VerificationStrategy defaultVerificationStrategy() {
        return this.options.verificationStrategies().activatingOnlyContractKeysFor(this.options.authorizingAddress(), this.options.onlyDelegatableContractKeysActive(), this.options.enhancement().nativeOperations());
    }

    @NonNull
    public HederaWorldUpdater.Enhancement enhancement() {
        return this.options.enhancement();
    }

    @NonNull
    public SystemContractGasCalculator systemContractGasCalculator() {
        return this.options.gasCalculator();
    }

    @NonNull
    public HederaNativeOperations nativeOperations() {
        return this.options.enhancement().nativeOperations();
    }

    @Nullable
    public Call asExecutableCall() {
        T self = this.self();
        for (CallTranslator<T> translator : this.options.callTranslators()) {
            Call call = translator.translateCallAttempt(self);
            if (call == null) continue;
            return call;
        }
        return null;
    }

    @NonNull
    public AccountID senderId() {
        return this.senderId;
    }

    @NonNull
    public Address senderAddress() {
        return this.options.senderAddress();
    }

    public AddressIdConverter addressIdConverter() {
        return this.options.addressIdConverter();
    }

    public Configuration configuration() {
        return this.options.configuration();
    }

    public byte[] selector() {
        return this.selector;
    }

    public Bytes input() {
        return this.input;
    }

    public byte[] inputBytes() {
        return this.input.toArrayUnsafe();
    }

    public boolean isStaticCall() {
        return this.options.isStaticCall();
    }

    public boolean isRedirect() {
        return this.redirectAddress != null;
    }

    public boolean isSelector(Function ... functions) {
        for (Function function : functions) {
            if (!Arrays.equals(function.selector(), this.selector())) continue;
            return true;
        }
        return false;
    }

    public boolean isSelector(SystemContractMethod ... methods) {
        return this.isMethod(methods).isPresent();
    }

    @NonNull
    public Optional<SystemContractMethod> isMethod(SystemContractMethod ... methods) {
        for (SystemContractMethod method : methods) {
            if (!Arrays.equals(method.selector(), this.selector()) || !method.hasSupportedAddress(this.options.contractID())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public boolean isSelectorIfConfigEnabled(boolean configEnabled, SystemContractMethod ... methods) {
        return configEnabled && this.isSelector(methods);
    }

    private boolean isRedirectSelector(@NonNull byte[] functionSelector, @NonNull byte[] input) {
        return Arrays.equals(input, 0, functionSelector.length, functionSelector, 0, functionSelector.length);
    }

    public boolean isOnlyDelegatableContractKeysActive() {
        return this.options.onlyDelegatableContractKeysActive();
    }

    public SystemContractMethodRegistry getSystemContractMethodRegistry() {
        return this.options.systemContractMethodRegistry();
    }

    public ContractID systemContractID() {
        return this.options.contractID();
    }
}

