/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarallowance;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarallowance.HbarAllowanceTranslator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class HbarAllowanceCall
extends AbstractCall {
    private final AccountID owner;
    private final AccountID spender;

    public HbarAllowanceCall(@NonNull HasCallAttempt attempt, @Nullable AccountID owner, @NonNull AccountID spender) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), true);
        this.spender = Objects.requireNonNull(spender);
        this.owner = owner;
    }

    @Override
    public boolean allowsStaticFrame() {
        return true;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(MessageFrame frame) {
        Objects.requireNonNull(frame);
        long gasRequirement = this.gasCalculator.viewGasRequirement();
        if (this.owner == null || this.nativeOperations().getAccount(this.owner) == null) {
            return this.reversionWith(ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID, gasRequirement);
        }
        BigInteger allowance = this.getAllowance(this.nativeOperations().getAccount(this.owner), this.spender);
        return Call.PricedResult.gasOnly(FullResult.successResult(this.encodedAllowanceOutput(allowance), gasRequirement), ResponseCodeEnum.SUCCESS, true);
    }

    @NonNull
    private BigInteger getAllowance(@NonNull Account ownerAccount, @NonNull AccountID spenderID) {
        Objects.requireNonNull(ownerAccount);
        Objects.requireNonNull(spenderID);
        Optional<AccountCryptoAllowance> tokenAllowance = Objects.requireNonNull(ownerAccount).cryptoAllowances().stream().filter(allowance -> allowance.spenderIdOrThrow().equals((Object)spenderID)).findFirst();
        return BigInteger.valueOf(tokenAllowance.map(AccountCryptoAllowance::amount).orElse(0L));
    }

    @NonNull
    private ByteBuffer encodedAllowanceOutput(@NonNull BigInteger allowance) {
        Objects.requireNonNull(allowance);
        return HbarAllowanceTranslator.HBAR_ALLOWANCE_PROXY.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)allowance));
    }
}

