/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulecall;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.DispatchForResponseCodeHssCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulecall.ScheduleCallDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleCallTranslator
extends AbstractCallTranslator<HssCallAttempt> {
    public static final SystemContractMethod SCHEDULE_CALL = SystemContractMethod.declare("scheduleCall(address,uint256,uint256,uint64,bytes)", "(int64,address)").withCategories(SystemContractMethod.Category.SCHEDULE);
    public static final SystemContractMethod SCHEDULE_CALL_WITH_PAYER = SystemContractMethod.declare("scheduleCallWithPayer(address,address,uint256,uint256,uint64,bytes)", "(int64,address)").withCategories(SystemContractMethod.Category.SCHEDULE);
    public static final SystemContractMethod EXECUTE_CALL_ON_PAYER_SIGNATURE = SystemContractMethod.declare("executeCallOnPayerSignature(address,address,uint256,uint256,uint64,bytes)", "(int64,address)").withCategories(SystemContractMethod.Category.SCHEDULE);
    private final ScheduleCallDecoder decoder;

    @Inject
    public ScheduleCallTranslator(@NonNull ScheduleCallDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HSS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(SCHEDULE_CALL, SCHEDULE_CALL_WITH_PAYER, EXECUTE_CALL_ON_PAYER_SIGNATURE);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HssCallAttempt attempt) {
        if (((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractScheduleCallEnabled()) {
            return attempt.isMethod(SCHEDULE_CALL, SCHEDULE_CALL_WITH_PAYER, EXECUTE_CALL_ON_PAYER_SIGNATURE);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HssCallAttempt attempt) {
        Set<Key> keys = attempt.keySetFor();
        TransactionBody body = this.decoder.decodeScheduleCall(attempt, keys);
        return new DispatchForResponseCodeHssCall(attempt.enhancement(), attempt.systemContractGasCalculator(), body.scheduleCreateOrThrow().payerAccountIDOrThrow(), body, attempt.defaultVerificationStrategy(), ScheduleCallTranslator::gasRequirement, keys, DispatchForResponseCodeHssCall::scheduleCreateResultEncode);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.SCHEDULE_CREATE_CONTRACT_CALL, payerId);
    }
}

