/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.allowance;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.allowance.GetAllowanceCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GetAllowanceTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod GET_ALLOWANCE = SystemContractMethod.declare("allowance(address,address,address)", "(int64,uint256)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALLOWANCE);
    public static final SystemContractMethod ERC_GET_ALLOWANCE = SystemContractMethod.declare("allowance(address,address)", "(uint256)").withVia(SystemContractMethod.CallVia.PROXY).withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALLOWANCE);

    @Inject
    public GetAllowanceTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(GET_ALLOWANCE, ERC_GET_ALLOWANCE);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(GET_ALLOWANCE, ERC_GET_ALLOWANCE);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(ERC_GET_ALLOWANCE)) {
            Tuple call = ERC_GET_ALLOWANCE.decodeCall(attempt.inputBytes());
            return new GetAllowanceCall(attempt.addressIdConverter(), attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken(), (Address)call.get(0), (Address)call.get(1), true, attempt.isStaticCall());
        }
        Tuple call = GET_ALLOWANCE.decodeCall(attempt.inputBytes());
        Address token = (Address)call.get(0);
        Address owner = (Address)call.get(1);
        Address spender = (Address)call.get(2);
        return new GetAllowanceCall(attempt.addressIdConverter(), attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.linkedToken(ConversionUtils.fromHeadlongAddress(token)), owner, spender, false, attempt.isStaticCall());
    }

    private boolean matchesErcSelector(@NonNull byte[] selector) {
        return Arrays.equals(selector, ERC_GET_ALLOWANCE.selector());
    }
}

