/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.ActiveContractVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.scope.EitherOrVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.scope.SpecificCryptoVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.address_0x167.CreateTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ClassicCreatesCall
extends AbstractCall {
    private static final long FIXED_GAS_COST = 100000L;
    @Nullable
    final TransactionBody syntheticCreate;
    private final VerificationStrategy verificationStrategy;
    private final AccountID spenderId;

    public ClassicCreatesCall(@NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable TransactionBody syntheticCreate, @NonNull VerificationStrategy verificationStrategy, @NonNull AccountID spender) {
        super(systemContractGasCalculator, enhancement, false);
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.spenderId = spender;
        this.syntheticCreate = syntheticCreate;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        if (this.syntheticCreate == null) {
            return Call.PricedResult.gasOnly(FullResult.haltResult(CustomExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT, FrameUtils.contractsConfigOf(frame).precompileHtsDefaultGasCost()), ResponseCodeEnum.INVALID_TRANSACTION_BODY, false);
        }
        long timestampSeconds = frame.getBlockValues().getTimestamp();
        Timestamp timestamp = Timestamp.newBuilder().seconds(timestampSeconds).build();
        TransactionBody syntheticCreateWithId = this.syntheticCreate.copyBuilder().transactionID(TransactionID.newBuilder().accountID(AccountID.DEFAULT).transactionValidStart(timestamp).build()).build();
        long baseCost = this.gasCalculator.feeCalculatorPriceInTinyBars(syntheticCreateWithId, this.spenderId);
        long nonGasCost = baseCost + baseCost / 5L - this.gasCalculator.gasCostInTinybars(100000L);
        if (frame.getValue().lessThan((UInt256Value)Wei.of((long)nonGasCost))) {
            return this.completionWith(100000L, this.systemContractOperations().externalizePreemptedDispatch(this.syntheticCreate, ResponseCodeEnum.INSUFFICIENT_TX_FEE, HederaFunctionality.TOKEN_CREATE), ReturnTypes.RC_AND_ADDRESS_ENCODER.encode((Object)Tuple.of((Object)ResponseCodeEnum.INSUFFICIENT_TX_FEE.protoOrdinal(), (Object)ReturnTypes.ZERO_ADDRESS)));
        }
        this.operations().collectHtsFee(this.spenderId, nonGasCost);
        TokenCreateTransactionBody op = this.syntheticCreate.tokenCreationOrThrow();
        ResponseCodeEnum validity = this.validityOfSynth(op);
        if (validity != ResponseCodeEnum.OK) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(validity, 100000L), validity, true);
        }
        VerificationStrategy dispatchVerificationStrategy = this.verificationStrategyFor(frame, op);
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(this.syntheticCreate, dispatchVerificationStrategy, this.spenderId, ContractCallStreamBuilder.class);
        recordBuilder.status(ReturnTypes.standardized(recordBuilder.status()));
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            return Call.PricedResult.gasPlus(FullResult.revertResult(recordBuilder, 100000L), status, false, nonGasCost);
        }
        List customFees = op.customFees();
        ByteBuffer encodedOutput = op.tokenType() == TokenType.FUNGIBLE_COMMON ? (customFees.isEmpty() ? CreateTranslator.CREATE_FUNGIBLE_TOKEN_V1.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)ConversionUtils.headlongAddressOf(recordBuilder.tokenID()))) : CreateTranslator.CREATE_FUNGIBLE_WITH_CUSTOM_FEES_V1.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)ConversionUtils.headlongAddressOf(recordBuilder.tokenID())))) : (customFees.isEmpty() ? CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_V1.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)ConversionUtils.headlongAddressOf(recordBuilder.tokenID()))) : CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_WITH_CUSTOM_FEES_V1.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)ConversionUtils.headlongAddressOf(recordBuilder.tokenID()))));
        return Call.PricedResult.gasPlus(FullResult.successResult(encodedOutput, 100000L, recordBuilder), status, false, nonGasCost);
    }

    @Override
    @NonNull
    public SchedulableTransactionBody asSchedulableDispatchIn() {
        if (this.syntheticCreate == null) {
            return super.asSchedulableDispatchIn();
        }
        return SchedulableTransactionBody.newBuilder().tokenCreation(this.syntheticCreate.tokenCreation()).build();
    }

    private ResponseCodeEnum validityOfSynth(@NonNull TokenCreateTransactionBody op) {
        if (op.symbol().isEmpty()) {
            return ResponseCodeEnum.MISSING_TOKEN_SYMBOL;
        }
        Account treasuryAccount = this.nativeOperations().getAccount(op.treasuryOrThrow());
        if (treasuryAccount == null) {
            return ResponseCodeEnum.INVALID_ACCOUNT_ID;
        }
        return ResponseCodeEnum.OK;
    }

    private VerificationStrategy verificationStrategyFor(@NonNull MessageFrame frame, @NonNull TokenCreateTransactionBody op) {
        LegacyActivation legacyActivation = this.legacyActivationIn(frame);
        VerificationStrategy baseVerificationStrategy = this.hasCryptoAdminKey(op) ? new EitherOrVerificationStrategy(this.verificationStrategy, new SpecificCryptoVerificationStrategy(op.adminKeyOrThrow())) : this.verificationStrategy;
        return FrameUtils.stackIncludesActiveAddress(frame, legacyActivation.besuAddress()) ? new EitherOrVerificationStrategy(baseVerificationStrategy, new ActiveContractVerificationStrategy(FrameUtils.entityIdFactory(frame).newContractId(legacyActivation.contractNum()), legacyActivation.pbjAddress(), false, ActiveContractVerificationStrategy.UseTopLevelSigs.NO)) : baseVerificationStrategy;
    }

    private boolean hasCryptoAdminKey(@NonNull TokenCreateTransactionBody op) {
        return op.hasAdminKey() && (op.adminKeyOrThrow().hasEd25519() || op.adminKeyOrThrow().hasEcdsaSecp256k1());
    }

    private LegacyActivation legacyActivationIn(@NonNull MessageFrame frame) {
        String literal = ((ContractsConfig)FrameUtils.configOf(frame).getConfigData(ContractsConfig.class)).keysLegacyActivations();
        long contractNum = Long.parseLong(literal.substring(literal.indexOf("[") + 1, literal.indexOf("]")));
        Bytes pbjAddress = Bytes.wrap((byte[])ConversionUtils.asEvmAddress(contractNum));
        return new LegacyActivation(contractNum, pbjAddress, ConversionUtils.pbjToBesuAddress(pbjAddress));
    }

    private record LegacyActivation(long contractNum, Bytes pbjAddress, Address besuAddress) {
    }
}

