/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.freeze;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.freeze.FreezeUnfreezeDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FreezeUnfreezeTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod FREEZE = SystemContractMethod.declare("freezeToken(address,address)", "(int64)").withCategories(SystemContractMethod.Category.FREEZE_UNFREEZE);
    public static final SystemContractMethod UNFREEZE = SystemContractMethod.declare("unfreezeToken(address,address)", "(int64)").withCategories(SystemContractMethod.Category.FREEZE_UNFREEZE);
    private final FreezeUnfreezeDecoder decoder;

    @Inject
    public FreezeUnfreezeTranslator(@NonNull FreezeUnfreezeDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(FREEZE, UNFREEZE);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(FREEZE, UNFREEZE);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, this.bodyForClassic(attempt), attempt.isSelector(FREEZE) ? FreezeUnfreezeTranslator::freezeGasRequirement : FreezeUnfreezeTranslator::unfreezeGasRequirement, DispatchForResponseCodeHtsCall.FailureCustomizer.NOOP_CUSTOMIZER);
    }

    public static long freezeGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.FREEZE, payerId);
    }

    public static long unfreezeGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.UNFREEZE, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (Arrays.equals(attempt.selector(), FREEZE.selector())) {
            return this.decoder.decodeFreeze(attempt);
        }
        return this.decoder.decodeUnfreeze(attempt);
    }
}

