/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo;

import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractNonRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.TokenTupleUtils;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo.address_0x167.FungibleTokenInfoTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.LedgerConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public class FungibleTokenInfoCall
extends AbstractNonRevertibleTokenViewCall {
    private final Configuration configuration;
    private final boolean isStaticCall;
    private final Function function;

    public FungibleTokenInfoCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isStaticCall, @Nullable Token token, @NonNull Configuration configuration, Function function) {
        super(gasCalculator, enhancement, token);
        this.configuration = Objects.requireNonNull(configuration);
        this.isStaticCall = isStaticCall;
        this.function = function;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, this.gasCalculator.viewGasRequirement(), token), ResponseCodeEnum.SUCCESS, true);
    }

    @Override
    @NonNull
    protected FullResult viewCallResultWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return this.fullResultsFor(status, gasRequirement, Token.DEFAULT);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum status, long gasRequirement, @NonNull Token token) {
        Objects.requireNonNull(status);
        Objects.requireNonNull(token);
        LedgerConfig ledgerConfig = (LedgerConfig)this.configuration.getConfigData(LedgerConfig.class);
        String ledgerId = Bytes.wrap((byte[])ledgerConfig.id().toByteArray()).toString();
        if (this.isStaticCall && status != ResponseCodeEnum.SUCCESS) {
            return FullResult.revertResult(status, gasRequirement);
        }
        return this.function.getName().equals(FungibleTokenInfoTranslator.FUNGIBLE_TOKEN_INFO.methodName()) && this.function.getOutputs().equals(FungibleTokenInfoTranslator.FUNGIBLE_TOKEN_INFO.getOutputs()) ? FullResult.successResult(FungibleTokenInfoTranslator.FUNGIBLE_TOKEN_INFO.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)TokenTupleUtils.fungibleTokenInfoTupleFor(token, ledgerId, 1))), gasRequirement) : FullResult.successResult(com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.fungibletokeninfo.address_0x16c.FungibleTokenInfoTranslator.FUNGIBLE_TOKEN_INFO_16C.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)TokenTupleUtils.fungibleTokenInfoTupleFor(token, ledgerId, 2))), gasRequirement);
    }
}

