/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantrevokekyc;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.token.TokenGrantKycTransactionBody;
import com.hedera.hapi.node.token.TokenRevokeKycTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantrevokekyc.GrantRevokeKycTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GrantRevokeKycDecoder {
    @Inject
    public GrantRevokeKycDecoder() {
    }

    public TransactionBody decodeGrantKyc(@NonNull HtsCallAttempt attempt) {
        Tuple call = GrantRevokeKycTranslator.GRANT_KYC.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenGrantKyc(this.grantKyc((Address)call.get(0), (Address)call.get(1), attempt)).build();
    }

    private TokenGrantKycTransactionBody grantKyc(@NonNull Address tokenAddress, @NonNull Address accountAddress, @NonNull HtsCallAttempt attempt) {
        return TokenGrantKycTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress)).account(attempt.addressIdConverter().convert(accountAddress)).build();
    }

    public TransactionBody decodeRevokeKyc(@NonNull HtsCallAttempt attempt) {
        Tuple call = GrantRevokeKycTranslator.REVOKE_KYC.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenRevokeKyc(this.revokeKyc((Address)call.get(0), (Address)call.get(1), attempt)).build();
    }

    private TokenRevokeKycTransactionBody revokeKyc(@NonNull Address tokenAddress, @NonNull Address accountAddress, @NonNull HtsCallAttempt attempt) {
        return TokenRevokeKycTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress)).account(attempt.addressIdConverter().convert(accountAddress)).build();
    }
}

