/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isapprovedforall;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isapprovedforall.IsApprovedForAllTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IsApprovedForAllCall
extends AbstractRevertibleTokenViewCall {
    private final Address owner;
    private final Address operator;
    private final boolean isErcRedirect;

    public IsApprovedForAllCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token, @NonNull Address owner, @NonNull Address operator, boolean isErcRedirect) {
        super(gasCalculator, enhancement, token);
        this.owner = Objects.requireNonNull(owner);
        this.operator = Objects.requireNonNull(operator);
        this.isErcRedirect = isErcRedirect;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        if (token.tokenType() != TokenType.NON_FUNGIBLE_UNIQUE) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_TOKEN_ID, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_ID, true);
        }
        boolean verdict = false;
        long ownerNum = ConversionUtils.accountNumberForEvmReference(this.owner, this.nativeOperations());
        long operatorNum = ConversionUtils.accountNumberForEvmReference(this.operator, this.nativeOperations());
        if (operatorNum > 0L && ownerNum > 0L) {
            verdict = this.operatorMatches(Objects.requireNonNull(this.nativeOperations().getAccount(this.enhancement.nativeOperations().entityIdFactory().newAccountId(ownerNum))), this.enhancement.nativeOperations().entityIdFactory().newAccountId(operatorNum), token.tokenIdOrThrow());
        }
        if (this.isErcRedirect) {
            return Call.PricedResult.gasOnly(FullResult.successResult(IsApprovedForAllTranslator.ERC_IS_APPROVED_FOR_ALL.getOutputs().encode((Object)Tuple.singleton((Object)verdict)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
        }
        return Call.PricedResult.gasOnly(FullResult.successResult(IsApprovedForAllTranslator.CLASSIC_IS_APPROVED_FOR_ALL.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)verdict)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }

    private boolean operatorMatches(@NonNull Account owner, @NonNull AccountID operatorId, @NonNull TokenID tokenId) {
        List operatorApprovals = Optional.ofNullable(owner.approveForAllNftAllowances()).orElse(Collections.emptyList());
        for (AccountApprovalForAllAllowance approval : operatorApprovals) {
            if (!tokenId.equals((Object)approval.tokenIdOrThrow()) || !operatorId.equals((Object)approval.spenderIdOrThrow())) continue;
            return true;
        }
        return false;
    }
}

