/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isassociated;

import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isassociated.IsAssociatedCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IsAssociatedTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod IS_ASSOCIATED = SystemContractMethod.declare("isAssociated()", "(bool)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.TOKEN_QUERY, SystemContractMethod.Category.ASSOCIATION);

    @Inject
    public IsAssociatedTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(IS_ASSOCIATED);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        if (!attempt.isRedirect()) {
            return Optional.empty();
        }
        return attempt.isMethod(IS_ASSOCIATED);
    }

    @Override
    public final Call callFrom(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return new IsAssociatedCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.senderId(), attempt.redirectToken());
    }
}

