/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.name;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.name.NameTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class NameCall
extends AbstractRevertibleTokenViewCall {
    public NameCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token) {
        super(gasCalculator, enhancement, token);
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        ByteBuffer output = NameTranslator.NAME.getOutputs().encode((Object)Tuple.singleton((Object)token.name()));
        return Call.PricedResult.gasOnly(FullResult.successResult(output, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }

    public static boolean matches(@NonNull byte[] selector) {
        Objects.requireNonNull(selector);
        return Arrays.equals(selector, NameTranslator.NAME.selector());
    }

    public static NameCall from(@NonNull HtsCallAttempt attempt) {
        return new NameCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken());
    }
}

