/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.pauses;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.pauses.PausesDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PausesTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod PAUSE = SystemContractMethod.declare("pauseToken(address)", "(int64)").withCategories(SystemContractMethod.Category.PAUSE_UNPAUSE);
    public static final SystemContractMethod UNPAUSE = SystemContractMethod.declare("unpauseToken(address)", "(int64)").withCategories(SystemContractMethod.Category.PAUSE_UNPAUSE);
    private final PausesDecoder decoder;

    @Inject
    public PausesTranslator(@NonNull PausesDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(PAUSE, UNPAUSE);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(PAUSE, UNPAUSE);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, this.bodyForClassic(attempt), attempt.isSelector(PAUSE) ? PausesTranslator::pauseGasRequirement : PausesTranslator::unpauseGasRequirement);
    }

    public static long pauseGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.PAUSE, payerId);
    }

    public static long unpauseGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.UNPAUSE, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(PAUSE)) {
            return this.decoder.decodePause(attempt);
        }
        return this.decoder.decodeUnpause(attempt);
    }
}

