/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenkey;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractNonRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenkey.address_0x167.TokenKeyTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class TokenKeyCall
extends AbstractNonRevertibleTokenViewCall {
    private final Key key;
    private final boolean isStaticCall;

    public TokenKeyCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isStaticCall, @Nullable Token token, @Nullable Key key) {
        super(gasCalculator, enhancement, token);
        this.key = key;
        this.isStaticCall = isStaticCall;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        if (this.key == null) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.KEY_NOT_PROVIDED, this.gasCalculator.viewGasRequirement(), Key.DEFAULT), ResponseCodeEnum.KEY_NOT_PROVIDED, true);
        }
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, this.gasCalculator.viewGasRequirement(), this.key), ResponseCodeEnum.SUCCESS, true);
    }

    @Override
    @NonNull
    protected FullResult viewCallResultWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return this.fullResultsFor(status, gasRequirement, Key.DEFAULT);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum status, long gasRequirement, @NonNull Key key) {
        if (this.isStaticCall && status != ResponseCodeEnum.SUCCESS) {
            return FullResult.revertResult(status, 0L);
        }
        return FullResult.successResult(TokenKeyTranslator.TOKEN_KEY.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)ConversionUtils.keyTupleFor(key))), gasRequirement);
    }
}

