/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.streams.SidecarType;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.exec.utils.PropagatedCallFailureRef;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.infra.StorageAccessTracker;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.frame.MessageFrame;

@Singleton
public class FrameBuilder {
    private static final int MAX_STACK_SIZE = 1024;

    @Inject
    public FrameBuilder() {
    }

    public MessageFrame buildInitialFrameWith(@NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater worldUpdater, @NonNull HederaEvmContext context, @NonNull Configuration config, @NonNull OpsDurationCounter opsDurationCounter, @NonNull FeatureFlags featureFlags, @NonNull Address from, @NonNull Address to, long intrinsicGas, @NonNull CodeFactory codeFactory) {
        Wei value = transaction.weiValue();
        LedgerConfig ledgerConfig = (LedgerConfig)config.getConfigData(LedgerConfig.class);
        Address nominalCoinbase = ConversionUtils.asLongZeroAddress(ledgerConfig.fundingAccount());
        Map<String, Object> contextVariables = this.contextVariablesFrom(config, opsDurationCounter, context);
        MessageFrame.Builder builder = MessageFrame.builder().maxStackSize(1024).worldUpdater(worldUpdater.updater()).initialGas(transaction.gasAvailable(intrinsicGas)).originator(from).gasPrice(Wei.of((long)context.gasPrice())).blobGasPrice(Wei.ONE).sender(from).value(value).apparentValue(value).blockValues(context.blockValuesOf(transaction.gasLimit())).completer(unused -> {}).isStatic(context.staticCall()).miningBeneficiary(nominalCoinbase).blockHashLookup(context.blocks()::blockHashOf).contextVariables(contextVariables);
        if (transaction.isCreate()) {
            return this.finishedAsCreate(to, builder, transaction, codeFactory);
        }
        return this.finishedAsCall(to, worldUpdater, builder, transaction, featureFlags, (ContractsConfig)config.getConfigData(ContractsConfig.class), codeFactory);
    }

    private Map<String, Object> contextVariablesFrom(@NonNull Configuration config, @NonNull OpsDurationCounter opsDurationCounter, @NonNull HederaEvmContext context) {
        HashMap<String, Object> contextEntries = new HashMap<String, Object>();
        contextEntries.put("contractsConfig", config);
        contextEntries.put("tinybarValues", context.tinybarValues());
        contextEntries.put("systemContractGasCalculator", context.systemContractGasCalculator());
        contextEntries.put("propagatedCallFailure", new PropagatedCallFailureRef());
        ContractsConfig contractConfig = (ContractsConfig)config.getConfigData(ContractsConfig.class);
        Set sidecars = contractConfig.sidecars();
        if (sidecars.contains(SidecarType.CONTRACT_STATE_CHANGE)) {
            contextEntries.put("storageAccessTracker", new StorageAccessTracker());
        }
        if (sidecars.contains(SidecarType.CONTRACT_ACTION)) {
            contextEntries.put("actionSidecars", true);
            if (contractConfig.sidecarValidationEnabled()) {
                contextEntries.put("actionSidecarsValidation", true);
            }
        }
        if (sidecars.contains(SidecarType.CONTRACT_BYTECODE)) {
            contextEntries.put("bytecodeSidecars", true);
        }
        if (context.isTransaction()) {
            contextEntries.put("hapiRecordBuilder", context.streamBuilder());
            contextEntries.put("pendingCreationBuilder", context.pendingCreationRecordBuilderReference());
        }
        contextEntries.put("opsDurationCounter", opsDurationCounter);
        return contextEntries;
    }

    private MessageFrame finishedAsCreate(@NonNull Address to, @NonNull MessageFrame.Builder builder, @NonNull HederaEvmTransaction transaction, CodeFactory codeFactory) {
        return builder.type(MessageFrame.Type.CONTRACT_CREATION).address(to).contract(to).inputData(Bytes.EMPTY).code(codeFactory.createCode(transaction.evmPayload(), false)).build();
    }

    private MessageFrame finishedAsCall(@NonNull Address to, @NonNull HederaWorldUpdater worldUpdater, @NonNull MessageFrame.Builder builder, @NonNull HederaEvmTransaction transaction, @NonNull FeatureFlags featureFlags, @NonNull ContractsConfig config, @NonNull CodeFactory codeFactory) {
        CodeV0 code = CodeV0.EMPTY_CODE;
        ContractID contractId = transaction.contractIdOrThrow();
        boolean contractMustBePresent = this.contractMustBePresent(config, featureFlags, contractId);
        if (this.contractDeleted(worldUpdater, contractId)) {
            HandleException.validateTrue((!contractMustBePresent || transaction.permitsMissingContract() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
            return builder.type(MessageFrame.Type.MESSAGE_CALL).address(to).contract(to).inputData(transaction.evmPayload()).code((Code)code).build();
        }
        HederaEvmAccount account = worldUpdater.getHederaAccount(contractId);
        if (account != null) {
            code = account.getEvmCode(Bytes.wrap((byte[])transaction.payload().toByteArray()), codeFactory);
            if (code.equals((Object)CodeV0.EMPTY_CODE)) {
                HandleException.validateTrue((boolean)this.emptyCodePossiblyAllowed(contractMustBePresent, transaction), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            }
        } else if (contractMustBePresent) {
            HandleException.validateTrue((boolean)transaction.permitsMissingContract(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
        }
        return builder.type(MessageFrame.Type.MESSAGE_CALL).address(to).contract(to).inputData(transaction.evmPayload()).code((Code)code).build();
    }

    private boolean contractDeleted(@NonNull HederaWorldUpdater worldUpdater, @NonNull ContractID contractId) {
        Account contract = worldUpdater.enhancement().nativeOperations().readableAccountStore().getContractById(contractId);
        if (contract != null) {
            return contract.deleted();
        }
        return false;
    }

    private boolean contractMustBePresent(@NonNull ContractsConfig config, @NonNull FeatureFlags featureFlags, @NonNull ContractID contractID) {
        Long possiblyGrandFatheredEntityNumOf = contractID.hasContractNum() ? contractID.contractNum() : null;
        return !featureFlags.isAllowCallsToNonContractAccountsEnabled(config, possiblyGrandFatheredEntityNumOf);
    }

    private boolean emptyCodePossiblyAllowed(boolean contractMustBePresent, @NonNull HederaEvmTransaction transaction) {
        return transaction.isEthereumTransaction() || transaction.hasValue() || !contractMustBePresent;
    }
}

