/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.hooks.LambdaMappingEntries;
import com.hedera.hapi.node.hooks.LambdaMappingEntry;
import com.hedera.hapi.node.hooks.LambdaSStoreTransactionBody;
import com.hedera.hapi.node.hooks.LambdaStorageSlot;
import com.hedera.hapi.node.hooks.LambdaStorageUpdate;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.node.state.hooks.EvmHookType;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.contract.ReadableEvmHookStore;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LambdaSStoreHandler
implements TransactionHandler {
    public static final long MAX_UPDATE_BYTES_LEN = 32L;

    @Inject
    public LambdaSStoreHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        LambdaSStoreTransactionBody op = context.body().lambdaSstoreOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasHookId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        HookId hookId = op.hookIdOrThrow();
        PreCheckException.validateTruePreCheck((boolean)hookId.hasEntityId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        HookEntityId.EntityIdOneOfType ownerType = (HookEntityId.EntityIdOneOfType)hookId.entityIdOrThrow().entityId().kind();
        PreCheckException.validateTruePreCheck((ownerType == HookEntityId.EntityIdOneOfType.ACCOUNT_ID ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        for (LambdaStorageUpdate update : op.storageUpdates()) {
            if (update.hasStorageSlot()) {
                this.validateSlot(update.storageSlotOrThrow());
                continue;
            }
            if (update.hasMappingEntries()) {
                LambdaMappingEntries mappingEntries = update.mappingEntriesOrThrow();
                this.validateWord(mappingEntries.mappingSlot());
                for (LambdaMappingEntry entry : mappingEntries.entries()) {
                    this.validateEntry(entry);
                }
                continue;
            }
            throw new PreCheckException(ResponseCodeEnum.EMPTY_LAMBDA_STORAGE_UPDATE);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        LambdaSStoreTransactionBody op = context.body().lambdaSstoreOrThrow();
        ReadableEvmHookStore store = (ReadableEvmHookStore)context.createStore(ReadableEvmHookStore.class);
        EvmHookState hook = store.getEvmHook(op.hookIdOrThrow());
        PreCheckException.validateTruePreCheck((hook != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
        PreCheckException.validateTruePreCheck((hook.type() == EvmHookType.LAMBDA ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_IS_NOT_A_LAMBDA);
        AccountID ownerAccountId = hook.hookIdOrThrow().entityIdOrThrow().accountIdOrThrow();
        if (hook.hasAdminKey()) {
            context.requireKeyOrThrow(ownerAccountId, ownerKey -> Key.newBuilder().thresholdKey(ThresholdKey.newBuilder().threshold(1).keys(new KeyList(List.of(ownerKey, hook.adminKeyOrThrow())))).build(), ResponseCodeEnum.INVALID_HOOK_ID);
        } else {
            context.requireKeyOrThrowOnDeleted(ownerAccountId, ResponseCodeEnum.INVALID_HOOK_ID);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        LambdaSStoreTransactionBody op = context.body().lambdaSstoreOrThrow();
        WritableEvmHookStore lambdaStore = (WritableEvmHookStore)context.storeFactory().writableStore(WritableEvmHookStore.class);
        List storageUpdates = op.storageUpdates();
        HooksConfig config = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        HandleException.validateTrue((storageUpdates.size() <= config.maxLambdaSStoreUpdates() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOO_MANY_LAMBDA_STORAGE_UPDATES);
        int delta = lambdaStore.updateStorage(op.hookIdOrThrow(), op.storageUpdates());
        if (delta != 0) {
            TokenServiceApi tokenServiceApi = (TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class);
            AccountID ownerAccountId = op.hookIdOrThrow().entityIdOrThrow().accountIdOrThrow();
            tokenServiceApi.updateLambdaStorageSlots(ownerAccountId, delta);
        }
    }

    private void validateSlot(@NonNull LambdaStorageSlot slot) throws PreCheckException {
        this.validateWord(slot.key());
        this.validateWord(slot.value());
    }

    private void validateEntry(@NonNull LambdaMappingEntry entry) throws PreCheckException {
        if (entry.hasKey()) {
            this.validateWord(entry.keyOrThrow());
        }
        this.validateWord(entry.value());
    }

    private void validateWord(@NonNull Bytes bytes) throws PreCheckException {
        PreCheckException.validateTruePreCheck((bytes.length() <= 32L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.LAMBDA_STORAGE_UPDATE_BYTES_TOO_LONG);
        Bytes minimalBytes = HookUtils.minimalRepresentationOf((Bytes)bytes);
        PreCheckException.validateTruePreCheck((bytes == minimalBytes ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.LAMBDA_STORAGE_UPDATE_BYTES_MUST_USE_MINIMAL_REPRESENTATION);
    }
}

