/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.node.state.hooks.LambdaSlotKey;
import com.hedera.node.app.service.contract.ReadableEvmHookStore;
import com.hedera.node.app.service.contract.impl.schemas.V065ContractSchema;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReadableEvmHookStoreImpl
implements ReadableEvmHookStore {
    private final ReadableKVState<LambdaSlotKey, SlotValue> storage;
    private final ReadableKVState<HookId, EvmHookState> hookStates;

    public ReadableEvmHookStoreImpl(@NonNull ReadableStates states) {
        Objects.requireNonNull(states);
        this.storage = states.get(V065ContractSchema.LAMBDA_STORAGE_STATE_ID);
        this.hookStates = states.get(V065ContractSchema.EVM_HOOK_STATES_STATE_ID);
    }

    @Nullable
    public EvmHookState getEvmHook(@NonNull HookId hookId) {
        Objects.requireNonNull(hookId);
        return (EvmHookState)this.hookStates.get((Object)hookId);
    }

    @Nullable
    public SlotValue getSlotValue(@NonNull LambdaSlotKey key) {
        Objects.requireNonNull(key);
        return (SlotValue)this.storage.get((Object)key);
    }

    public EvmHookView getView(@NonNull HookId hookId, @NonNull List<Bytes> keys) throws HandleException {
        Objects.requireNonNull(hookId);
        Objects.requireNonNull(keys);
        EvmHookState state = (EvmHookState)this.hookStates.get((Object)hookId);
        if (state == null) {
            throw new HandleException(ResponseCodeEnum.HOOK_NOT_FOUND);
        }
        ArrayList<Slot> slots = new ArrayList<Slot>(keys.size());
        keys.forEach(key -> {
            LambdaSlotKey slotKey = new LambdaSlotKey(hookId, key);
            SlotValue slotValue = (SlotValue)this.storage.get((Object)slotKey);
            slots.add(new Slot(slotKey, slotValue));
        });
        return new EvmHookView(state, slots);
    }

    public record EvmHookView(@NonNull EvmHookState state, @NonNull List<Slot> selectedSlots) {
        public EvmHookView {
            Objects.requireNonNull(state);
            Objects.requireNonNull(selectedSlots);
        }

        public Bytes firstStorageKey() {
            return this.state.firstContractStorageKey();
        }
    }

    public record Slot(@NonNull LambdaSlotKey key, @Nullable SlotValue value) {
        public Slot {
            Objects.requireNonNull(key);
        }

        @Nullable
        public Bytes maybeBytesValue() {
            return this.value == null || Bytes.EMPTY.equals((Object)this.value.value()) ? null : this.value.value();
        }

        @NonNull
        public Bytes effectivePrevKey() {
            return this.value == null ? Bytes.EMPTY : this.value.previousKey();
        }

        @NonNull
        public Bytes effectiveNextKey() {
            return this.value == null ? Bytes.EMPTY : this.value.nextKey();
        }
    }
}

