/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.ResolveUsernameApiOp;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.DelegatingTimeoutProxy;
import org.identityconnectors.framework.impl.api.LoggingProxy;

public abstract class AbstractConnectorFacade
implements ConnectorFacade {
    private final APIConfigurationImpl _configuration;

    public AbstractConnectorFacade(APIConfigurationImpl configuration) {
        Assertions.nullCheck((Object)configuration, (String)"configuration");
        this._configuration = (APIConfigurationImpl)SerializerUtil.cloneObject((Object)configuration);
        this._configuration.setConnectorInfo(configuration.getConnectorInfo());
    }

    public final APIOperation getOperation(Class<? extends APIOperation> api) {
        if (!this.getSupportedOperations().contains(api)) {
            return null;
        }
        return this.getOperationImplementation(api);
    }

    public final Set<Class<? extends APIOperation>> getSupportedOperations() {
        return this._configuration.getSupportedOperations();
    }

    public final Schema schema() {
        return ((SchemaApiOp)this.getOperationCheckSupported(SchemaApiOp.class)).schema();
    }

    public final Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        CreateApiOp op = (CreateApiOp)this.getOperationCheckSupported(CreateApiOp.class);
        return op.create(oclass, attrs, options);
    }

    public final void delete(ObjectClass objClass, Uid uid, OperationOptions options) {
        ((DeleteApiOp)this.getOperationCheckSupported(DeleteApiOp.class)).delete(objClass, uid, options);
    }

    public final void search(ObjectClass oclass, Filter filter, ResultsHandler handler, OperationOptions options) {
        ((SearchApiOp)this.getOperationCheckSupported(SearchApiOp.class)).search(oclass, filter, handler, options);
    }

    public final Uid update(ObjectClass objclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        return ((UpdateApiOp)this.getOperationCheckSupported(UpdateApiOp.class)).update(objclass, uid, attrs, options);
    }

    public final Uid addAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        return ((UpdateApiOp)this.getOperationCheckSupported(UpdateApiOp.class)).addAttributeValues(objclass, uid, attrs, options);
    }

    public final Uid removeAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        return ((UpdateApiOp)this.getOperationCheckSupported(UpdateApiOp.class)).removeAttributeValues(objclass, uid, attrs, options);
    }

    public final Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        return ((AuthenticationApiOp)this.getOperationCheckSupported(AuthenticationApiOp.class)).authenticate(objectClass, username, password, options);
    }

    public final Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        return ((ResolveUsernameApiOp)this.getOperationCheckSupported(ResolveUsernameApiOp.class)).resolveUsername(objectClass, username, options);
    }

    public final Object runScriptOnConnector(ScriptContext request, OperationOptions options) {
        return ((ScriptOnConnectorApiOp)this.getOperationCheckSupported(ScriptOnConnectorApiOp.class)).runScriptOnConnector(request, options);
    }

    public final Object runScriptOnResource(ScriptContext request, OperationOptions options) {
        return ((ScriptOnResourceApiOp)this.getOperationCheckSupported(ScriptOnResourceApiOp.class)).runScriptOnResource(request, options);
    }

    public final ConnectorObject getObject(ObjectClass objClass, Uid uid, OperationOptions options) {
        return ((GetApiOp)this.getOperationCheckSupported(GetApiOp.class)).getObject(objClass, uid, options);
    }

    public final void test() {
        ((TestApiOp)this.getOperationCheckSupported(TestApiOp.class)).test();
    }

    public final void validate() {
        ((ValidateApiOp)this.getOperationCheckSupported(ValidateApiOp.class)).validate();
    }

    public final void sync(ObjectClass objClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        ((SyncApiOp)this.getOperationCheckSupported(SyncApiOp.class)).sync(objClass, token, handler, options);
    }

    public final SyncToken getLatestSyncToken(ObjectClass objectClass) {
        return ((SyncApiOp)this.getOperationCheckSupported(SyncApiOp.class)).getLatestSyncToken(objectClass);
    }

    private APIOperation getOperationCheckSupported(Class<? extends APIOperation> api) {
        if (!this.getSupportedOperations().contains(api)) {
            String MSG = "Operation ''{0}'' not supported.";
            String str = MessageFormat.format("Operation ''{0}'' not supported.", api);
            throw new UnsupportedOperationException(str);
        }
        return this.getOperationImplementation(api);
    }

    protected APIOperation newAPIOperationProxy(Class<? extends APIOperation> api, InvocationHandler handler) {
        return (APIOperation)Proxy.newProxyInstance(api.getClassLoader(), new Class[]{api}, handler);
    }

    protected abstract APIOperation getOperationImplementation(Class<? extends APIOperation> var1);

    protected final APIConfigurationImpl getAPIConfiguration() {
        return this._configuration;
    }

    protected final APIOperation createTimeoutProxy(Class<? extends APIOperation> api, APIOperation target) {
        int timeout = this.getAPIConfiguration().getTimeout(api);
        int bufferSize = this.getAPIConfiguration().getProducerBufferSize();
        DelegatingTimeoutProxy handler = new DelegatingTimeoutProxy(target, timeout, bufferSize);
        return this.newAPIOperationProxy(api, handler);
    }

    protected final APIOperation createLoggingProxy(Class<? extends APIOperation> api, APIOperation target) {
        return this.newAPIOperationProxy(api, new LoggingProxy(api, target));
    }
}

