/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.nativelib.secp256r1;

import java.util.Arrays;
import org.hyperledger.besu.nativelib.secp256r1.Signature;
import org.hyperledger.besu.nativelib.secp256r1.besuNativeEC.BesuNativeEC;
import org.hyperledger.besu.nativelib.secp256r1.besuNativeEC.KeyRecoveryResult;
import org.hyperledger.besu.nativelib.secp256r1.besuNativeEC.SignResult;
import org.hyperledger.besu.nativelib.secp256r1.besuNativeEC.VerifyResult;

public class LibSECP256R1 {
    static int VERIFICATION_SUCCESS = 1;
    static int PUBLIC_KEY_LENGTH = 64;
    static int CURVE_BYTE_LENGTH = 32;

    public byte[] keyRecovery(byte[] dataHash, byte[] signatureR, byte[] signatureS, int signatureV) throws IllegalArgumentException {
        KeyRecoveryResult.KeyRecoveryResultByValue result = BesuNativeEC.INSTANCE.p256_key_recovery(dataHash, dataHash.length, this.convertToNativeRepresentation(signatureR), this.convertToNativeRepresentation(signatureS), signatureV);
        String errorMessage = new String(result.error_message).trim();
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
        return Arrays.copyOf(result.public_key, PUBLIC_KEY_LENGTH);
    }

    public Signature sign(byte[] dataHash, byte[] privateKey, byte[] publicKey) throws IllegalArgumentException {
        SignResult.SignResultByValue result = BesuNativeEC.INSTANCE.p256_sign(dataHash, dataHash.length, privateKey, publicKey);
        String errorMessage = new String(result.error_message).trim();
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
        return new Signature(this.convertToNonNegativeRepresentation(result.signature_r), this.convertToNonNegativeRepresentation(result.signature_s), result.signature_v);
    }

    public boolean verify(byte[] dataHash, byte[] signatureR, byte[] signatureS, byte[] publicKey) throws IllegalArgumentException {
        VerifyResult.VerifyResultByValue result = BesuNativeEC.INSTANCE.p256_verify(dataHash, dataHash.length, this.convertToNativeRepresentation(signatureR), this.convertToNativeRepresentation(signatureS), publicKey);
        if (result.verified < 0) {
            String errorMessage = new String(result.error_message).trim();
            throw new IllegalArgumentException(errorMessage);
        }
        return result.verified == VERIFICATION_SUCCESS;
    }

    private byte[] convertToNonNegativeRepresentation(byte[] signature) {
        if ((signature[0] & 0x80) != 128) {
            return Arrays.copyOf(signature, CURVE_BYTE_LENGTH);
        }
        byte[] nonNegativeSignature = new byte[CURVE_BYTE_LENGTH + 1];
        nonNegativeSignature[0] = 0;
        System.arraycopy(signature, 0, nonNegativeSignature, 1, CURVE_BYTE_LENGTH);
        return nonNegativeSignature;
    }

    private byte[] convertToNativeRepresentation(byte[] signature) {
        if (this.isConvertedSignature(signature)) {
            byte[] nativeSignature = new byte[CURVE_BYTE_LENGTH];
            System.arraycopy(signature, 1, nativeSignature, 0, signature.length - 1);
            return nativeSignature;
        }
        if (signature.length < CURVE_BYTE_LENGTH) {
            byte[] nativeSignature = new byte[CURVE_BYTE_LENGTH];
            System.arraycopy(signature, 0, nativeSignature, CURVE_BYTE_LENGTH - signature.length, signature.length);
            return nativeSignature;
        }
        if (signature.length != CURVE_BYTE_LENGTH) {
            throw new IllegalArgumentException("Signature must be " + CURVE_BYTE_LENGTH + " bytes long, but has " + signature.length + " bytes.");
        }
        return signature;
    }

    private boolean isConvertedSignature(byte[] signature) {
        return signature.length == CURVE_BYTE_LENGTH + 1 && signature[0] == 0 && (signature[1] & 0x80) == 128;
    }
}

