/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.http.http2.ConnectionFlowControl;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.WindowSize;
import java.util.Objects;
import java.util.function.BiConsumer;

abstract class FlowControlImpl
implements FlowControl {
    private static final System.Logger LOGGER_INBOUND = System.getLogger(FlowControl.class.getName() + ".ifc");
    private static final System.Logger LOGGER_OUTBOUND = System.getLogger(FlowControl.class.getName() + ".ofc");
    private final int streamId;

    FlowControlImpl(int streamId) {
        this.streamId = streamId;
    }

    abstract WindowSize connectionWindowSize();

    abstract WindowSize streamWindowSize();

    @Override
    public void resetStreamWindowSize(int size) {
        this.streamWindowSize().resetWindowSize(size);
    }

    @Override
    public int getRemainingWindowSize() {
        return Math.max(0, Integer.min(this.connectionWindowSize().getRemainingWindowSize(), this.streamWindowSize().getRemainingWindowSize()));
    }

    public String toString() {
        return "FlowControlImpl{streamId=" + this.streamId + ", connectionWindowSize=" + String.valueOf(this.connectionWindowSize()) + ", streamWindowSize=" + String.valueOf(this.streamWindowSize()) + "}";
    }

    protected int streamId() {
        return this.streamId;
    }

    static class Outbound
    extends FlowControlImpl
    implements FlowControl.Outbound {
        private final ConnectionFlowControl.Type type;
        private final ConnectionFlowControl connectionFlowControl;
        private final WindowSize.Outbound streamWindowSize;

        Outbound(ConnectionFlowControl.Type type, int streamId, ConnectionFlowControl connectionFlowControl) {
            super(streamId);
            this.type = type;
            this.connectionFlowControl = connectionFlowControl;
            this.streamWindowSize = WindowSize.createOutbound(type, streamId, connectionFlowControl);
        }

        @Override
        WindowSize connectionWindowSize() {
            return this.connectionFlowControl.outbound();
        }

        @Override
        WindowSize streamWindowSize() {
            return this.streamWindowSize;
        }

        @Override
        public void decrementWindowSize(int decrement) {
            long strRemaining = this.streamWindowSize().decrementWindowSize(decrement);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_OUTBOUND.log(System.Logger.Level.DEBUG, String.format("%s OFC STR %d: -%d(%d)", new Object[]{this.type, this.streamId(), decrement, strRemaining}));
            }
            long connRemaining = this.connectionWindowSize().decrementWindowSize(decrement);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_OUTBOUND.log(System.Logger.Level.DEBUG, String.format("%s OFC STR 0: -%d(%d)", new Object[]{this.type, decrement, connRemaining}));
            }
        }

        @Override
        public long incrementStreamWindowSize(int increment) {
            long remaining = this.streamWindowSize.incrementWindowSize(increment);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_OUTBOUND.log(System.Logger.Level.DEBUG, String.format("%s OFC STR %d: +%d(%d)", new Object[]{this.type, this.streamId(), increment, remaining}));
            }
            this.connectionFlowControl.outbound().triggerUpdate();
            return remaining;
        }

        @Override
        public Http2FrameData[] cut(Http2FrameData frame) {
            return frame.cut(this.getRemainingWindowSize());
        }

        @Override
        public void blockTillUpdate() {
            this.connectionFlowControl.outbound().blockTillUpdate();
            this.streamWindowSize.blockTillUpdate();
        }

        @Override
        public int maxFrameSize() {
            return this.connectionFlowControl.maxFrameSize();
        }
    }

    static class Inbound
    extends FlowControlImpl
    implements FlowControl.Inbound {
        private final WindowSize.Inbound connectionWindowSize;
        private final WindowSize.Inbound streamWindowSize;
        private final ConnectionFlowControl.Type type;

        Inbound(ConnectionFlowControl.Type type, int streamId, int streamInitialWindowSize, int streamMaxFrameSize, WindowSize.Inbound connectionWindowSize, BiConsumer<Integer, Http2WindowUpdate> windowUpdateStreamWriter) {
            super(streamId);
            this.type = type;
            if (streamInitialWindowSize == 0) {
                throw new IllegalArgumentException("Window size in bytes for stream-level flow control was not set.");
            }
            Objects.requireNonNull(connectionWindowSize, "Window size in bytes for connection-level flow control was not set.");
            Objects.requireNonNull(windowUpdateStreamWriter, "Stream-level window update writer was not set.");
            this.connectionWindowSize = connectionWindowSize;
            this.streamWindowSize = WindowSize.createInbound(type, streamId, streamInitialWindowSize, streamMaxFrameSize, windowUpdateStreamWriter);
        }

        @Override
        WindowSize connectionWindowSize() {
            return this.connectionWindowSize;
        }

        @Override
        WindowSize streamWindowSize() {
            return this.streamWindowSize;
        }

        @Override
        public void decrementWindowSize(int decrement) {
            long strRemaining = this.streamWindowSize().decrementWindowSize(decrement);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_INBOUND.log(System.Logger.Level.DEBUG, String.format("%s IFC STR %d: -%d(%d)", new Object[]{this.type, this.streamId(), decrement, strRemaining}));
            }
            long connRemaining = this.connectionWindowSize().decrementWindowSize(decrement);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_INBOUND.log(System.Logger.Level.DEBUG, String.format("%s IFC STR 0: -%d(%d)", new Object[]{this.type, decrement, connRemaining}));
            }
        }

        @Override
        public void incrementWindowSize(int increment) {
            long strRemaining = this.streamWindowSize.incrementWindowSize(increment);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_INBOUND.log(System.Logger.Level.DEBUG, String.format("%s IFC STR %d: +%d(%d)", new Object[]{this.type, this.streamId(), increment, strRemaining}));
            }
            long conRemaining = this.connectionWindowSize.incrementWindowSize(increment);
            if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER_INBOUND.log(System.Logger.Level.DEBUG, String.format("%s IFC STR 0: +%d(%d)", new Object[]{this.type, increment, conRemaining}));
            }
        }
    }
}

