/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;

public class Http2FrameHeader {
    public static final int LENGTH = 9;
    private final Http2FrameType type;
    private final int length;
    private final int flags;
    private final int streamId;

    Http2FrameHeader(Http2FrameType type, int length, int flags, int streamId) {
        this.type = type;
        this.length = length;
        this.flags = flags;
        this.streamId = streamId;
    }

    public static Http2FrameHeader create(BufferData bytes) {
        int length = bytes.readInt24();
        short type = (short)bytes.read();
        short flags = (short)bytes.read();
        int streamIdentifier = bytes.readInt32() & Integer.MAX_VALUE;
        return new Http2FrameHeader(Http2FrameType.byId(type), length, flags, streamIdentifier);
    }

    public static <T extends Http2Flag> Http2FrameHeader create(int length, Http2FrameTypes<T> frameType, T flags, int streamIdentifier) {
        return new Http2FrameHeader(frameType.type(), length, flags.value(), streamIdentifier);
    }

    public String toString() {
        return this.streamId + " " + String.valueOf((Object)this.type) + " (" + this.length + " bytes)";
    }

    public <T extends Http2Flag> T flags(Http2FrameTypes<T> types) {
        if (types.type() != this.type) {
            throw new IllegalArgumentException("Attempting to get flags for type " + String.valueOf((Object)types.type()) + " in frame header of type " + String.valueOf((Object)this.type));
        }
        return types.flags(this.flags);
    }

    public Http2FrameType type() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public int flags() {
        return this.flags;
    }

    public int streamId() {
        return this.streamId;
    }

    public BufferData write() {
        BufferData bufferData = BufferData.create((int)9);
        bufferData.writeInt24(this.length);
        bufferData.writeInt8(this.type.type());
        bufferData.writeInt8(this.flags);
        bufferData.writeInt32(this.streamId);
        return bufferData;
    }

    public Http2Flag typedFlags() {
        return Http2FrameTypes.get(this.type).flags(this.flags);
    }
}

