/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Setting;

abstract class Http2SettingBase<T>
implements Http2Setting<T> {
    static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private final String name;
    private final T defaultValue;
    private final int identifier;

    Http2SettingBase(String name, int identifier, T defaultValue) {
        this.name = name;
        this.identifier = identifier;
        this.defaultValue = defaultValue;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.name;
    }

    protected String name() {
        return this.name;
    }

    static final class NumberSetting
    extends Http2SettingBase<Long> {
        NumberSetting(String name, int identifier, Long defaultValue) {
            super(name, identifier, NumberSetting.checkMax(name, defaultValue));
        }

        @Override
        public Long read(BufferData frame) {
            return frame.readUnsignedInt32();
        }

        @Override
        public void write(BufferData data, Long value) {
            NumberSetting.checkMax(this.name(), value);
            data.writeInt16(this.identifier());
            data.writeUnsignedInt32(value.longValue());
        }

        private static Long checkMax(String name, long value) {
            if (value > 0xFFFFFFFFL) {
                throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Value too big for setting " + name + ", value: " + value);
            }
            return value;
        }
    }

    static final class BooleanSetting
    extends Http2SettingBase<Boolean> {
        BooleanSetting(String name, int identifier, Boolean defaultValue) {
            super(name, identifier, defaultValue);
        }

        @Override
        public Boolean read(BufferData frame) {
            int value = frame.readInt32();
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Setting " + this.name() + " only allows values 0 and 1, actual value: " + value);
        }

        @Override
        public void write(BufferData data, Boolean value) {
            data.writeInt16(this.identifier());
            data.writeInt32(value != false ? 1 : 0);
        }
    }
}

