/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.http.http2.ConnectionFlowControl;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.WindowSizeImpl;
import java.util.function.BiConsumer;

public interface WindowSize {
    public static final int DEFAULT_WIN_SIZE = 65535;
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int MAX_MAX_FRAME_SIZE = 0xFFFFFF;
    public static final int MAX_WIN_SIZE = Integer.MAX_VALUE;

    public static Inbound createInbound(ConnectionFlowControl.Type type, int streamId, int initialWindowSize, int maxFrameSize, BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter) {
        return new WindowSizeImpl.Inbound(type, streamId, initialWindowSize, maxFrameSize, windowUpdateWriter);
    }

    public static Outbound createOutbound(ConnectionFlowControl.Type type, int streamId, ConnectionFlowControl connectionFlowControl) {
        return new WindowSizeImpl.Outbound(type, streamId, connectionFlowControl);
    }

    public static Inbound createInboundNoop(int streamId, BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter) {
        return new WindowSizeImpl.InboundNoop(streamId, windowUpdateWriter);
    }

    public void resetWindowSize(int var1);

    public long incrementWindowSize(int var1);

    public int decrementWindowSize(int var1);

    public int getRemainingWindowSize();

    public static interface Outbound
    extends WindowSize {
        public void triggerUpdate();

        public void blockTillUpdate();
    }

    public static interface Inbound
    extends WindowSize {
    }
}

