/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.validation;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public interface AttributeValidator {
    public static final int MAX_NESTED_KEY_LEVELS = 15;

    public void validateKey(@NonNull Key var1);

    public void validateKey(@NonNull Key var1, @NonNull ResponseCodeEnum var2);

    public void validateMemo(@Nullable String var1);

    public void validateExpiry(long var1);

    public void validateAutoRenewPeriod(long var1);

    public static boolean isImmutableKey(@NonNull Key key) {
        Objects.requireNonNull(key);
        return key.hasKeyList() && key.equals((Object)KeyUtils.IMMUTABILITY_SENTINEL_KEY);
    }

    public static boolean isKeyRemoval(@NonNull Key source) {
        Objects.requireNonNull(source);
        return AttributeValidator.isImmutableKey(source);
    }
}

