/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.pricing;

import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.SubType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequiredPriceTypes {
    private static final EnumSet<SubType> ONLY_DEFAULT = EnumSet.of(SubType.DEFAULT);
    private static final Map<HederaFunctionality, EnumSet<SubType>> FUNCTIONS_WITH_REQUIRED_SUBTYPES = new EnumMap<HederaFunctionality, EnumSet<SubType>>(HederaFunctionality.class);

    RequiredPriceTypes() {
        throw new IllegalStateException("Uninstantiable");
    }

    public static Set<SubType> requiredTypesFor(HederaFunctionality function) {
        return FUNCTIONS_WITH_REQUIRED_SUBTYPES.getOrDefault(function, ONLY_DEFAULT);
    }

    static {
        List.of(HederaFunctionality.TokenMint, HederaFunctionality.TokenBurn, HederaFunctionality.TokenAccountWipe).forEach(function -> FUNCTIONS_WITH_REQUIRED_SUBTYPES.put((HederaFunctionality)function, EnumSet.of(SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_NON_FUNGIBLE_UNIQUE)));
        FUNCTIONS_WITH_REQUIRED_SUBTYPES.put(HederaFunctionality.TokenCreate, EnumSet.of(SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES, SubType.TOKEN_NON_FUNGIBLE_UNIQUE, SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES));
        FUNCTIONS_WITH_REQUIRED_SUBTYPES.put(HederaFunctionality.CryptoTransfer, EnumSet.of(SubType.DEFAULT, SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES, SubType.TOKEN_NON_FUNGIBLE_UNIQUE, SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES));
        FUNCTIONS_WITH_REQUIRED_SUBTYPES.put(HederaFunctionality.ScheduleCreate, EnumSet.of(SubType.DEFAULT, SubType.SCHEDULE_CREATE_CONTRACT_CALL));
    }
}

