/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.google.common.base.MoreObjects;
import com.hedera.node.app.hapi.fees.usage.crypto.AllowanceId;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoContextUtils;
import com.hederahashgraph.api.proto.java.CryptoApproveAllowanceTransactionBody;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CryptoApproveAllowanceMeta {
    private final long effectiveNow;
    private final long msgBytesUsed;
    private final Map<Long, Long> cryptoAllowances;
    private final int cryptoAllowancesCount;
    private final Map<AllowanceId, Long> tokenAllowances;
    private final Set<AllowanceId> nftAllowances;

    public CryptoApproveAllowanceMeta(Builder builder) {
        this.effectiveNow = builder.effectiveNow;
        this.msgBytesUsed = builder.msgBytesUsed;
        this.cryptoAllowances = builder.cryptoAllowances;
        this.cryptoAllowancesCount = this.cryptoAllowances.size();
        this.tokenAllowances = builder.tokenAllowances;
        this.nftAllowances = builder.nftAllowances;
    }

    public CryptoApproveAllowanceMeta(CryptoApproveAllowanceTransactionBody cryptoApproveTxnBody, long transactionValidStartSecs) {
        this.effectiveNow = transactionValidStartSecs;
        this.msgBytesUsed = this.bytesUsedInTxn(cryptoApproveTxnBody);
        this.cryptoAllowances = CryptoContextUtils.convertToCryptoMap(cryptoApproveTxnBody.getCryptoAllowancesList());
        this.cryptoAllowancesCount = cryptoApproveTxnBody.getCryptoAllowancesCount();
        this.tokenAllowances = CryptoContextUtils.convertToTokenMap(cryptoApproveTxnBody.getTokenAllowancesList());
        this.nftAllowances = CryptoContextUtils.convertToNftMap(cryptoApproveTxnBody.getNftAllowancesList());
    }

    public int getCryptoAllowancesCount() {
        return this.cryptoAllowancesCount;
    }

    private int bytesUsedInTxn(CryptoApproveAllowanceTransactionBody op) {
        return op.getCryptoAllowancesCount() * 36 + op.getTokenAllowancesCount() * 40 + op.getNftAllowancesCount() * 36 + CryptoContextUtils.countSerials(op.getNftAllowancesList()) * 8;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getEffectiveNow() {
        return this.effectiveNow;
    }

    public long getMsgBytesUsed() {
        return this.msgBytesUsed;
    }

    public Map<Long, Long> getCryptoAllowances() {
        return this.cryptoAllowances;
    }

    public Map<AllowanceId, Long> getTokenAllowances() {
        return this.tokenAllowances;
    }

    public Set<AllowanceId> getNftAllowances() {
        return this.nftAllowances;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cryptoAllowances", this.cryptoAllowances).add("tokenAllowances", this.tokenAllowances).add("nftAllowances", this.nftAllowances).add("effectiveNow", this.effectiveNow).add("msgBytesUsed", this.msgBytesUsed).toString();
    }

    public static class Builder {
        private long effectiveNow;
        private long msgBytesUsed;
        private Map<Long, Long> cryptoAllowances;
        private Map<AllowanceId, Long> tokenAllowances;
        private Set<AllowanceId> nftAllowances;

        public Builder cryptoAllowances(Map<Long, Long> cryptoAllowances) {
            this.cryptoAllowances = cryptoAllowances;
            return this;
        }

        public Builder tokenAllowances(Map<AllowanceId, Long> tokenAllowances) {
            this.tokenAllowances = tokenAllowances;
            return this;
        }

        public Builder nftAllowances(Set<AllowanceId> nftAllowances) {
            this.nftAllowances = nftAllowances;
            return this;
        }

        public Builder effectiveNow(long now) {
            this.effectiveNow = now;
            return this;
        }

        public Builder msgBytesUsed(long msgBytesUsed) {
            this.msgBytesUsed = msgBytesUsed;
            return this;
        }

        public CryptoApproveAllowanceMeta build() {
            return new CryptoApproveAllowanceMeta(this);
        }
    }
}

