/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.schedule;

import com.hedera.node.app.hapi.fees.usage.schedule.entities.ScheduleEntitySizes;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.SchedulableTransactionBody;
import java.nio.charset.StandardCharsets;

public class ExtantScheduleContext {
    static final long METADATA_SIZE = 120L;
    private final int numSigners;
    private final Key adminKey;
    private final String memo;
    private final boolean resolved;
    private final SchedulableTransactionBody scheduledTxn;

    private ExtantScheduleContext(Builder builder) {
        this.resolved = builder.resolved;
        this.numSigners = builder.numSigners;
        this.memo = builder.memo;
        this.adminKey = builder.adminKey;
        this.scheduledTxn = builder.scheduledTxn;
    }

    public long nonBaseRb() {
        return 120L + (this.resolved ? 12L : 0L) + (long)this.memo.getBytes(StandardCharsets.UTF_8).length + (long)FeeBuilder.getAccountKeyStorageSize((Key)this.adminKey) + (long)this.scheduledTxn.getSerializedSize() + (long)ScheduleEntitySizes.SCHEDULE_ENTITY_SIZES.bytesUsedForSigningKeys(this.numSigners);
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public int numSigners() {
        return this.numSigners;
    }

    public String memo() {
        return this.memo;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public SchedulableTransactionBody scheduledTxn() {
        return this.scheduledTxn;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final int IS_RESOLVED_MASK = 1;
        private static final int SCHEDULED_TXN_MASK = 2;
        private static final int MEMO_MASK = 4;
        private static final int ADMIN_KEY_MASK = 8;
        private static final int NUM_SIGNERS_MASK = 16;
        private static final int ALL_FIELDS_MASK = 31;
        private int mask = 0;
        private int numSigners;
        private Key adminKey;
        private String memo;
        private boolean resolved;
        private SchedulableTransactionBody scheduledTxn;

        private Builder() {
        }

        public ExtantScheduleContext build() {
            if (this.mask != 31) {
                throw new IllegalStateException(String.format("Field mask is %d, not %d!", this.mask, 31));
            }
            return new ExtantScheduleContext(this);
        }

        public Builder setNumSigners(int numSigners) {
            this.numSigners = numSigners;
            this.mask |= 0x10;
            return this;
        }

        public Builder setScheduledTxn(SchedulableTransactionBody scheduledTxn) {
            this.scheduledTxn = scheduledTxn;
            this.mask |= 2;
            return this;
        }

        public Builder setMemo(String memo) {
            this.memo = memo;
            this.mask |= 4;
            return this;
        }

        public Builder setAdminKey(Key adminKey) {
            this.adminKey = adminKey;
            this.mask |= 8;
            return this;
        }

        public Builder setNoAdminKey() {
            this.adminKey = null;
            this.mask |= 8;
            return this;
        }

        public Builder setResolved(boolean flag) {
            this.resolved = flag;
            this.mask |= 1;
            return this;
        }
    }
}

