/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.util;

import com.google.common.base.MoreObjects;
import com.hederahashgraph.api.proto.java.UtilPrngTransactionBody;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UtilPrngMeta {
    private final long msgBytesUsed;

    public UtilPrngMeta(UtilPrngTransactionBody txn) {
        this.msgBytesUsed = txn.getRange() > 0 ? 4L : 0L;
    }

    public UtilPrngMeta(Builder builder) {
        this.msgBytesUsed = builder.msgBytes;
    }

    public long getMsgBytesUsed() {
        return this.msgBytesUsed;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("msgBytesUsed", this.msgBytesUsed).toString();
    }

    public static class Builder {
        private long msgBytes;

        public Builder msgBytesUsed(long msgBytes) {
            this.msgBytes = msgBytes;
            return this;
        }

        public UtilPrngMeta build() {
            return new UtilPrngMeta(this);
        }
    }
}

