/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport;

public enum Architecture {
    AMD64,
    ARM64,
    I386;


    public static Architecture current() {
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.contains("amd64") || osArch.contains("x86_64")) {
            return AMD64;
        }
        if (osArch.contains("arm64") || osArch.contains("aarch64")) {
            return ARM64;
        }
        if (osArch.contains("i386")) {
            return I386;
        }
        throw new IllegalStateException("Unsupported architecture: " + osArch);
    }
}

