/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport;

public enum OperatingSystem {
    WINDOWS,
    LINUX,
    DARWIN;


    public static OperatingSystem current() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux")) {
            return LINUX;
        }
        if (osName.contains("mac")) {
            return DARWIN;
        }
        throw new IllegalStateException("Unsupported operating system: " + osName);
    }
}

