/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import org.hyperledger.besu.crypto.altbn128.AbstractFieldPoint;
import org.hyperledger.besu.crypto.altbn128.FieldElement;
import org.hyperledger.besu.crypto.altbn128.Fq;

public class AltBn128Point
extends AbstractFieldPoint<AltBn128Point> {
    static final Fq B = Fq.create(3L);
    static final AltBn128Point INFINITY = new AltBn128Point(Fq.zero(), Fq.zero());

    public static final AltBn128Point g1() {
        return new AltBn128Point(Fq.create(1L), Fq.create(2L));
    }

    public AltBn128Point(Fq x, Fq y) {
        super(x, y);
    }

    public Fq getX() {
        return (Fq)this.x;
    }

    public Fq getY() {
        return (Fq)this.y;
    }

    public boolean isOnCurve() {
        if (!this.x.isValid() || !this.y.isValid()) {
            return false;
        }
        if (this.isInfinity()) {
            return true;
        }
        return this.y.power(2).subtract(this.x.power(3)).equals(B);
    }

    @Override
    protected AltBn128Point infinity() {
        return new AltBn128Point(Fq.zero(), Fq.zero());
    }

    @Override
    protected AltBn128Point newInstance(FieldElement x, FieldElement y) {
        return new AltBn128Point((Fq)x, (Fq)y);
    }
}

