/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.EnumValueImpl;
import io.helidon.common.types.TypeName;
import java.util.Objects;

public interface EnumValue {
    public static EnumValue create(TypeName enumType, String enumName) {
        Objects.requireNonNull(enumType);
        Objects.requireNonNull(enumName);
        return new EnumValueImpl(enumType, enumName);
    }

    public static <T extends Enum<T>> EnumValue create(Class<T> type, T value) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(value);
        return new EnumValueImpl(TypeName.create(type), value.name());
    }

    public TypeName type();

    public String name();
}

