/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;

class ResolvedTypeImpl
implements ResolvedType,
Comparable<ResolvedType> {
    private final TypeName typeName;
    private final String resolvedName;
    private final boolean noTypes;

    ResolvedTypeImpl(TypeName typeName) {
        this.typeName = typeName;
        this.resolvedName = typeName.resolvedName();
        this.noTypes = typeName.typeArguments().isEmpty();
    }

    @Override
    public TypeName type() {
        return this.typeName;
    }

    @Override
    public String resolvedName() {
        return this.resolvedName;
    }

    public int hashCode() {
        return this.noTypes ? this.typeName.hashCode() : this.resolvedName.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedType)) {
            return false;
        }
        ResolvedType other = (ResolvedType)o;
        if (other instanceof ResolvedTypeImpl) {
            ResolvedTypeImpl rti = (ResolvedTypeImpl)other;
            return this.resolvedName.equals(rti.resolvedName);
        }
        return other.type().resolvedName().equals(this.resolvedName);
    }

    @Override
    public int compareTo(ResolvedType o) {
        int diff = this.resolvedName.compareTo(o.type().resolvedName());
        if (diff != 0) {
            return diff;
        }
        diff = Boolean.compare(this.typeName.primitive(), o.type().primitive());
        if (diff != 0) {
            return diff;
        }
        return Boolean.compare(this.typeName.array(), o.type().array());
    }

    public String toString() {
        return this.resolvedName;
    }
}

