/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Settings;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.http2.Http2Connection;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.spi.ServerConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

public class Http2Upgrader
implements Http1Upgrader {
    private static final byte[] SWITCHING_PROTOCOLS_BYTES = "HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: h2c\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private static final HeaderName HTTP2_SETTINGS_HEADER_NAME = HeaderNames.create((String)"HTTP2-Settings");
    private final Http2Config config;
    private final List<Http2SubProtocolSelector> subProtocolProviders;

    Http2Upgrader(Http2Config config, List<Http2SubProtocolSelector> subProtocolProviders) {
        this.config = config;
        this.subProtocolProviders = subProtocolProviders;
    }

    public static Http2Upgrader create(Http2Config config) {
        return new Http2Upgrader(config, List.of());
    }

    public String supportedProtocol() {
        return "h2c";
    }

    public ServerConnection upgrade(ConnectionContext ctx, HttpPrologue prologue, WritableHeaders<?> headers) {
        Http2Connection connection = new Http2Connection(ctx, this.config, this.subProtocolProviders);
        if (!headers.contains(HTTP2_SETTINGS_HEADER_NAME)) {
            throw new RuntimeException("Bad request -> not " + String.valueOf(HTTP2_SETTINGS_HEADER_NAME) + " header");
        }
        connection.clientSettings(Http2Upgrader.token68ToHttp2Settings(headers.get(HTTP2_SETTINGS_HEADER_NAME).valueBytes()));
        Http2Headers http2Headers = Http2Headers.create(headers);
        http2Headers.path(prologue.uriPath().rawPath());
        http2Headers.method(prologue.method());
        headers.remove(HeaderNames.HOST, it -> http2Headers.authority((String)it.get()));
        http2Headers.scheme("http");
        HttpPrologue newPrologue = HttpPrologue.create((String)"HTTP/2.0", (String)prologue.protocol(), (String)"2.0", (Method)prologue.method(), (UriPath)prologue.uriPath(), (UriQuery)prologue.query(), (UriFragment)prologue.fragment());
        connection.upgradeConnectionData(newPrologue, http2Headers);
        connection.expectPreface();
        DataWriter dataWriter = ctx.dataWriter();
        dataWriter.writeNow(BufferData.create((byte[])SWITCHING_PROTOCOLS_BYTES));
        return connection;
    }

    private static Http2Settings token68ToHttp2Settings(byte[] bytes) {
        return Http2Settings.create((BufferData)BufferData.create((byte[])Base64.getUrlDecoder().decode(bytes)));
    }
}

