/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.scheduled.ScheduleSignTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.handlers.AbstractScheduleHandler;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleFeeCharging;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.TransactionKeys;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleSignHandler
extends AbstractScheduleHandler
implements TransactionHandler {
    private final ScheduleOpsUsage scheduleOpsUsage = new ScheduleOpsUsage();

    @Inject
    public ScheduleSignHandler(@NonNull ScheduleFeeCharging feeCharging) {
        super(feeCharging);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        Objects.requireNonNull(body);
        PreCheckException.validateTruePreCheck((boolean)body.hasScheduleSign(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        ScheduleSignTransactionBody op = body.scheduleSignOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasScheduleID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SCHEDULE_ID);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ScheduleSignTransactionBody op = context.body().scheduleSignOrThrow();
        ReadableScheduleStore scheduleStore = (ReadableScheduleStore)context.createStore(ReadableScheduleStore.class);
        SchedulingConfig schedulingConfig = (SchedulingConfig)context.configuration().getConfigData(SchedulingConfig.class);
        boolean isLongTermEnabled = schedulingConfig.longTermEnabled();
        Schedule schedule = this.getValidated(op.scheduleIDOrThrow(), scheduleStore, isLongTermEnabled);
        TransactionKeys requiredKeys = this.getRequiredKeys(schedule, (arg_0, arg_1) -> ((PreHandleContext)context).allKeysForTransaction(arg_0, arg_1));
        context.optionalKey(requiredKeys.payerKey());
        context.optionalKeys(requiredKeys.requiredNonPayerKeys());
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        ScheduleSignTransactionBody op = context.body().scheduleSignOrThrow();
        WritableScheduleStore scheduleStore = (WritableScheduleStore)context.storeFactory().writableStore(WritableScheduleStore.class);
        Schedule schedule = scheduleStore.get(op.scheduleIDOrThrow());
        Instant consensusNow = context.consensusNow();
        SchedulingConfig schedulingConfig = (SchedulingConfig)context.configuration().getConfigData(SchedulingConfig.class);
        boolean isLongTermEnabled = schedulingConfig.longTermEnabled();
        ResponseCodeEnum validationResult = this.validate(schedule, consensusNow, isLongTermEnabled);
        HandleException.validateTrue((boolean)this.isMaybeExecutable(validationResult), (ResponseCodeEnum)validationResult);
        TransactionKeys transactionKeys = this.getTransactionKeysOrThrow(schedule, (arg_0, arg_1) -> ((HandleContext)context).allKeysForTransaction(arg_0, arg_1));
        List<Key> requiredKeys = this.allRequiredKeys(transactionKeys);
        List signatories = schedule.signatories();
        List<Key> newSignatories = ScheduleSignHandler.newSignatories(context.keyVerifier().authorizingSimpleKeys(), signatories, requiredKeys);
        schedule = schedule.copyBuilder().signatories(newSignatories).build();
        if (isLongTermEnabled && schedule.waitForExpiry()) {
            HandleException.validateTrue((!newSignatories.equals(signatories) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NO_NEW_VALID_SIGNATURES);
            scheduleStore.put(schedule);
        } else if (this.tryToExecuteSchedule(context, schedule, requiredKeys, validationResult, isLongTermEnabled)) {
            scheduleStore.put(ScheduleSignHandler.markedExecuted(schedule, consensusNow));
        } else {
            HandleException.validateTrue((!newSignatories.equals(signatories) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NO_NEW_VALID_SIGNATURES);
            scheduleStore.put(schedule);
        }
        ((ScheduleStreamBuilder)context.savepointStack().getBaseBuilder(ScheduleStreamBuilder.class)).scheduledTransactionID(HandlerUtility.transactionIdForScheduled(schedule));
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        ReadableScheduleStore scheduleStore = (ReadableScheduleStore)feeContext.readableStore(ReadableScheduleStore.class);
        Schedule schedule = scheduleStore.get(body.scheduleSignOrElse(ScheduleSignTransactionBody.DEFAULT).scheduleIDOrElse(ScheduleID.DEFAULT));
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)body), (SigValueObj)sigValueObj, schedule, ((LedgerConfig)feeContext.configuration().getConfigData(LedgerConfig.class)).scheduleTxExpiryTimeSecs()));
    }

    private FeeData usageGiven(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txn, @NonNull SigValueObj svo, @Nullable Schedule schedule, long scheduledTxExpiryTimeSecs) {
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        if (schedule != null) {
            return this.scheduleOpsUsage.scheduleSignUsage(txn, sigUsage, schedule.calculatedExpirationSecond());
        }
        long latestExpiry = txn.getTransactionID().getTransactionValidStart().getSeconds() + scheduledTxExpiryTimeSecs;
        return this.scheduleOpsUsage.scheduleSignUsage(txn, sigUsage, latestExpiry);
    }
}

