/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.MethodDescriptor;
import io.helidon.grpc.core.MarshallerSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.hiero.block.api.PublishStreamRequest;
import org.hiero.block.api.PublishStreamResponse;
import org.hiero.block.api.codec.PublishStreamRequestProtoCodec;
import org.hiero.block.api.codec.PublishStreamResponseProtoCodec;

public class RequestResponseMarshaller<T>
implements MethodDescriptor.Marshaller<T> {
    private final Codec<T> codec;

    RequestResponseMarshaller(@NonNull Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (clazz == PublishStreamRequest.class) {
            this.codec = new PublishStreamRequestProtoCodec();
        } else if (clazz == PublishStreamResponse.class) {
            this.codec = new PublishStreamResponseProtoCodec();
        } else {
            throw new IllegalArgumentException("Unsupported class: " + clazz.getName());
        }
    }

    public InputStream stream(@NonNull T obj) {
        Objects.requireNonNull(obj);
        return this.codec.toBytes(obj).toInputStream();
    }

    public T parse(@NonNull InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        try {
            return (T)this.codec.parse(Bytes.wrap((byte[])inputStream.readAllBytes()));
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Supplier
    implements MarshallerSupplier {
        public <T> MethodDescriptor.Marshaller<T> get(@NonNull Class<T> clazz) {
            return new RequestResponseMarshaller<T>(clazz);
        }
    }
}

