/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.InsufficientNonFeeDebitsException;
import com.hedera.node.app.spi.workflows.InsufficientServiceFeeException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.workflows.SolvencyPreCheck;
import com.hedera.node.app.workflows.handle.dispatch.DispatchValidator;
import com.hedera.node.app.workflows.handle.dispatch.ValidationResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AppFeeCharging
implements FeeCharging {
    private final SolvencyPreCheck solvencyPreCheck;

    @Inject
    public AppFeeCharging(@NonNull SolvencyPreCheck solvencyPreCheck) {
        this.solvencyPreCheck = Objects.requireNonNull(solvencyPreCheck);
    }

    public ValidationResult validate(@NonNull Account payer, @NonNull AccountID creatorId, @NonNull Fees fees, @NonNull TransactionBody body, boolean isDuplicate, @NonNull HederaFunctionality function, @NonNull HandleContext.TransactionCategory category) {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(creatorId);
        Objects.requireNonNull(fees);
        Objects.requireNonNull(body);
        Objects.requireNonNull(function);
        Objects.requireNonNull(category);
        try {
            this.solvencyPreCheck.checkSolvency(body, payer.accountIdOrThrow(), function, payer, isDuplicate ? fees.withoutServiceComponent() : fees, DispatchValidator.WorkflowCheck.NOT_INGEST, category == HandleContext.TransactionCategory.USER || category == HandleContext.TransactionCategory.SCHEDULED || category == HandleContext.TransactionCategory.NODE ? DispatchValidator.OfferedFeeCheck.CHECK_OFFERED_FEE : DispatchValidator.OfferedFeeCheck.SKIP_OFFERED_FEE_CHECK);
        }
        catch (InsufficientServiceFeeException e) {
            return ValidationResult.newPayerError(creatorId, payer, e.responseCode(), DispatchValidator.ServiceFeeStatus.UNABLE_TO_PAY_SERVICE_FEE, isDuplicate);
        }
        catch (InsufficientNonFeeDebitsException e) {
            return ValidationResult.newPayerError(creatorId, payer, e.responseCode(), DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, isDuplicate);
        }
        catch (PreCheckException e) {
            return ValidationResult.newCreatorError(creatorId, e.responseCode());
        }
        return ValidationResult.newSuccess(creatorId, payer);
    }

    public Fees charge(@NonNull FeeCharging.Context ctx, @NonNull FeeCharging.Validation validation, @NonNull Fees fees) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(validation);
        Objects.requireNonNull(fees);
        if (!(validation instanceof ValidationResult)) {
            throw new IllegalArgumentException("App charging strategy cannot use validation of type " + validation.getClass().getName());
        }
        ValidationResult result = (ValidationResult)validation;
        boolean shouldWaiveServiceFee = result.serviceFeeStatus() == DispatchValidator.ServiceFeeStatus.UNABLE_TO_PAY_SERVICE_FEE || result.duplicateStatus() == DispatchValidator.DuplicateStatus.DUPLICATE;
        Fees feesToCharge = shouldWaiveServiceFee ? fees.withoutServiceComponent() : fees;
        return switch (ctx.category()) {
            case HandleContext.TransactionCategory.USER, HandleContext.TransactionCategory.NODE -> ctx.charge(ctx.payerId(), feesToCharge, ctx.nodeAccountId(), null);
            default -> ctx.charge(ctx.payerId(), feesToCharge, null);
        };
    }

    public void refund(@NonNull FeeCharging.Context ctx, @NonNull Fees fees) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(fees);
        switch (ctx.category()) {
            case USER: 
            case NODE: {
                ctx.refund(ctx.payerId(), fees, ctx.nodeAccountId());
                break;
            }
            default: {
                ctx.refund(ctx.payerId(), fees);
            }
        }
    }
}

