/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.usage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.grpc.impl.usage.RpcEndpointName;
import com.hedera.node.app.grpc.impl.usage.UserAgent;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.GrpcUsageTrackerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcUsageTracker
implements ServerInterceptor {
    private static final int MAX_UA_LENGTH = 250;
    private static final Logger accessLogger = LogManager.getLogger((String)"grpc-access-log");
    private static final Metadata.Key<String> userAgentHeaderKey = Metadata.Key.of((String)"X-User-Agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Cache<String, UserAgent> userAgentCache;
    private final AtomicReference<UsageBucket> bucketRef;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean isEnabled = new AtomicBoolean(true);
    private final ConfigProvider configProvider;
    private final Clock clock;

    public GrpcUsageTracker(@NonNull ConfigProvider configProvider) {
        this(configProvider, Clock.systemUTC());
    }

    @VisibleForTesting
    GrpcUsageTracker(@NonNull ConfigProvider configProvider, @NonNull Clock clock) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.clock = Objects.requireNonNull(clock);
        GrpcUsageTrackerConfig config = (GrpcUsageTrackerConfig)configProvider.getConfiguration().getConfigData(GrpcUsageTrackerConfig.class);
        this.userAgentCache = Caffeine.newBuilder().maximumSize((long)config.userAgentCacheSize()).build();
        this.scheduleNext();
        Instant bucketTime = this.toBucketTime(clock.instant());
        this.bucketRef = new AtomicReference<UsageBucket>(new UsageBucket(bucketTime));
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        if (this.isEnabled.get()) {
            MethodDescriptor descriptor = call.getMethodDescriptor();
            String userAgentString = (String)headers.get(userAgentHeaderKey);
            String uaString = userAgentString != null && userAgentString.length() > 250 ? userAgentString.substring(0, 250) : userAgentString;
            RpcEndpointName rpcEndpointName = RpcEndpointName.from(descriptor);
            UserAgent userAgent = uaString == null || uaString.isBlank() ? UserAgent.UNSPECIFIED : (UserAgent)this.userAgentCache.get((Object)uaString, UserAgent::from);
            this.bucketRef.get().recordInteraction(rpcEndpointName, userAgent);
        }
        return next.startCall(call, headers);
    }

    @VisibleForTesting
    void logAndResetUsageData() {
        this.scheduleNext();
        Instant nextTime = this.toBucketTime(this.clock.instant());
        UsageBucket usageBucket = this.bucketRef.getAndSet(new UsageBucket(nextTime));
        String time = usageBucket.time.toString();
        usageBucket.usageData.forEach((rpcEndpointName, usagesByAgent) -> usagesByAgent.forEach((userAgent, counter) -> accessLogger.info("|time={}|service={}|method={}|sdkType={}|sdkVersion={}|count={}|", (Object)time, (Object)rpcEndpointName.serviceName(), (Object)rpcEndpointName.methodName(), (Object)userAgent.agentType().id(), (Object)userAgent.version(), (Object)counter.sum())));
    }

    private void scheduleNext() {
        GrpcUsageTrackerConfig config = (GrpcUsageTrackerConfig)this.configProvider.getConfiguration().getConfigData(GrpcUsageTrackerConfig.class);
        this.isEnabled.set(config.enabled());
        this.executor.schedule(this::logAndResetUsageData, (long)config.logIntervalMinutes(), TimeUnit.MINUTES);
    }

    @VisibleForTesting
    @NonNull
    Instant toBucketTime(@NonNull Instant time) {
        int bucketIntervalMinutes = ((GrpcUsageTrackerConfig)this.configProvider.getConfiguration().getConfigData(GrpcUsageTrackerConfig.class)).logIntervalMinutes();
        ZonedDateTime zdt = time.atZone(ZoneOffset.UTC);
        int minutes = zdt.getMinute();
        int rem = minutes % bucketIntervalMinutes;
        return time.truncatedTo(ChronoUnit.MINUTES).minus(rem, ChronoUnit.MINUTES);
    }

    @VisibleForTesting
    record UsageBucket(@NonNull Instant time, @NonNull ConcurrentMap<RpcEndpointName, ConcurrentMap<UserAgent, LongAdder>> usageData) {
        UsageBucket {
            Objects.requireNonNull(time, "time is required");
            Objects.requireNonNull(usageData, "usageData is required");
        }

        UsageBucket(@NonNull Instant time) {
            this(time, new ConcurrentHashMap<RpcEndpointName, ConcurrentMap<UserAgent, LongAdder>>(100));
        }

        void recordInteraction(@NonNull RpcEndpointName rpcEndpointName, @NonNull UserAgent userAgent) {
            Objects.requireNonNull(rpcEndpointName, "rpcName is required");
            Objects.requireNonNull(userAgent, "userAgent is required");
            this.usageData.computeIfAbsent(rpcEndpointName, __ -> new ConcurrentHashMap()).computeIfAbsent(userAgent, __ -> new LongAdder()).increment();
        }
    }
}

