/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.usage;

import com.hedera.node.app.grpc.impl.usage.UserAgentType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record UserAgent(@NonNull UserAgentType agentType, @NonNull String version) {
    private static final Pattern VERSION_REGEX = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final String UNKNOWN_STR = "Unknown";
    static final UserAgent UNKNOWN = new UserAgent(UserAgentType.UNKNOWN, "Unknown");
    static final UserAgent UNSPECIFIED = new UserAgent(UserAgentType.UNSPECIFIED, "Unknown");
    private static final Logger logger = LogManager.getLogger(UserAgent.class);

    public UserAgent {
        Objects.requireNonNull(agentType, "agentType is required");
        Objects.requireNonNull(version, "version is required");
    }

    @NonNull
    public static UserAgent from(@Nullable String userAgentStr) {
        String[] tokens;
        if (userAgentStr == null || userAgentStr.isBlank()) {
            return UNSPECIFIED;
        }
        UserAgent userAgent = null;
        for (String token : tokens = userAgentStr.split("\\s")) {
            String rawVersion;
            String[] subTokens = token.split("/");
            if (subTokens.length == 0 && userAgent == null) {
                userAgent = UNSPECIFIED;
                continue;
            }
            if (subTokens.length > 2 && userAgent == null) {
                userAgent = UNKNOWN;
                continue;
            }
            UserAgentType type = UserAgentType.fromString(subTokens[0]);
            String string = rawVersion = subTokens.length == 1 ? null : subTokens[1];
            String version = rawVersion == null || rawVersion.isBlank() || !type.isKnownType() ? UNKNOWN_STR : ("dev".equalsIgnoreCase(rawVersion) ? "dev" : (VERSION_REGEX.matcher(rawVersion).matches() ? rawVersion.toLowerCase() : UNKNOWN_STR));
            if (userAgent == null) {
                userAgent = new UserAgent(type, version);
                continue;
            }
            if (type.isKnownType() && userAgent.agentType.isKnownType()) {
                logger.warn("Multiple known user-agent types found: {}", (Object)userAgentStr);
                userAgent = UNKNOWN;
                continue;
            }
            if (!type.isKnownType() && userAgent.agentType.isKnownType() || !type.isKnownType()) continue;
            userAgent = new UserAgent(type, version);
        }
        if (userAgent == null) {
            userAgent = UNSPECIFIED;
        }
        if (!userAgent.agentType.isKnownType()) {
            logger.debug("Unknown user-agent detected: {}", (Object)userAgentStr);
        }
        return userAgent;
    }
}

