/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints;

import com.hedera.hapi.node.state.hints.CRSState;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.hints.PreprocessingVote;
import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface ReadableHintsStore {
    @NonNull
    public HintsConstruction getActiveConstruction();

    @NonNull
    public HintsConstruction getNextConstruction();

    default public boolean isReadyToAdopt(@NonNull Bytes rosterHash) {
        HintsConstruction construction = this.getNextConstruction();
        return construction.hasHintsScheme() && construction.targetRosterHash().equals((Object)rosterHash);
    }

    @Nullable
    public Bytes getActiveVerificationKey();

    @Nullable
    public HintsConstruction getConstructionFor(@NonNull ActiveRosters var1);

    @NonNull
    public Map<Long, PreprocessingVote> getVotes(long var1, @NonNull Set<Long> var3);

    @NonNull
    public List<HintsKeyPublication> getHintsKeyPublications(@NonNull Set<Long> var1, int var2);

    public CRSState getCrsState();

    @Nullable
    default public Bytes crsIfKnown() {
        Bytes candidate = this.getCrsState().crs();
        return candidate.length() > 0L ? candidate : null;
    }

    public List<CrsPublicationTransactionBody> getCrsPublications();

    public Map<Long, CrsPublicationTransactionBody> getOrderedCrsPublications(@NonNull Set<Long> var1);

    public record HintsKeyPublication(long nodeId, @NonNull Bytes hintsKey, int partyId, @NonNull Instant adoptionTime) {
        public HintsKeyPublication {
            Objects.requireNonNull(hintsKey);
            Objects.requireNonNull(adoptionTime);
        }
    }
}

