/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.hints.PreprocessingVote;
import com.hedera.node.app.hints.HintsLibrary;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.hints.ReadableHintsStore;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.impl.HintsContext;
import com.hedera.node.app.hints.impl.HintsController;
import com.hedera.node.app.hints.impl.HintsControllerImpl;
import com.hedera.node.app.hints.impl.HintsKeyAccessor;
import com.hedera.node.app.hints.impl.HintsSubmissions;
import com.hedera.node.app.hints.impl.InertHintsController;
import com.hedera.node.app.hints.impl.OnHintsFinished;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.node.app.roster.RosterTransitionWeights;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HintsControllers {
    private static final Logger log = LogManager.getLogger(HintsControllers.class);
    private static final long NO_CONSTRUCTION_ID = -1L;
    private final Executor executor;
    private final HintsKeyAccessor keyAccessor;
    private final HintsLibrary library;
    private final HintsSubmissions submissions;
    private final HintsContext context;
    private final Supplier<NodeInfo> selfNodeInfoSupplier;
    private final Supplier<Configuration> configurationSupplier;
    private final OnHintsFinished onHintsFinished;
    @Nullable
    private HintsController controller;

    @Inject
    public HintsControllers(@NonNull Executor executor, @NonNull HintsKeyAccessor keyAccessor, @NonNull HintsLibrary library, @NonNull HintsSubmissions submissions, @NonNull HintsContext context, @NonNull Supplier<NodeInfo> selfNodeInfoSupplier, @NonNull Supplier<Configuration> configurationSupplier, @NonNull OnHintsFinished onHintsFinished) {
        this.executor = Objects.requireNonNull(executor);
        this.keyAccessor = Objects.requireNonNull(keyAccessor);
        this.context = Objects.requireNonNull(context);
        this.library = Objects.requireNonNull(library);
        this.submissions = Objects.requireNonNull(submissions);
        this.selfNodeInfoSupplier = Objects.requireNonNull(selfNodeInfoSupplier);
        this.configurationSupplier = Objects.requireNonNull(configurationSupplier);
        this.onHintsFinished = Objects.requireNonNull(onHintsFinished);
    }

    @NonNull
    public HintsController getOrCreateFor(@NonNull ActiveRosters activeRosters, @NonNull HintsConstruction construction, @NonNull WritableHintsStore hintsStore) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(construction);
        Objects.requireNonNull(hintsStore);
        if (this.currentConstructionId() != construction.constructionId()) {
            if (this.controller != null) {
                this.controller.cancelPendingWork();
            }
            this.controller = this.newControllerFor(activeRosters, construction, hintsStore);
        }
        return Objects.requireNonNull(this.controller);
    }

    public Optional<HintsController> getInProgressById(long constructionId) {
        return this.currentConstructionId() == constructionId ? Optional.ofNullable(this.controller).filter(HintsController::isStillInProgress) : Optional.empty();
    }

    public Optional<HintsController> getInProgressForNumParties(int m) {
        return Optional.ofNullable(this.controller).filter(c -> c.hasNumParties(m));
    }

    public Optional<HintsController> getAnyInProgress() {
        return Optional.ofNullable(this.controller);
    }

    public void stop() {
        if (this.controller != null) {
            this.controller.cancelPendingWork();
            this.controller = null;
        }
    }

    private HintsController newControllerFor(@NonNull ActiveRosters activeRosters, @NonNull HintsConstruction construction, @NonNull WritableHintsStore hintsStore) {
        RosterTransitionWeights weights = activeRosters.transitionWeights();
        if (!weights.sourceNodesHaveTargetThreshold()) {
            return new InertHintsController(construction.constructionId());
        }
        int numParties = HintsService.partySizeForRosterNodeCount(weights.targetRosterSize());
        log.info("Creating controller for construction #{} from nodes {} to {} with {} hinTS parties", (Object)construction.constructionId(), weights.sourceNodeIds(), weights.targetNodeIds(), (Object)numParties);
        List<ReadableHintsStore.HintsKeyPublication> publications = hintsStore.getHintsKeyPublications(weights.targetNodeIds(), numParties);
        log.info("Construction #{} already has {} relevant keys published [{}]", (Object)construction.constructionId(), (Object)publications.size(), (Object)publications.stream().map(p -> "(" + p.nodeId() + " -> " + p.partyId() + ")").collect(Collectors.joining(", ")));
        Map<Long, PreprocessingVote> votes = hintsStore.getVotes(construction.constructionId(), weights.sourceNodeIds());
        long selfId = this.selfNodeInfoSupplier.get().nodeId();
        Bytes blsKeyPair = this.keyAccessor.getOrCreateBlsPrivateKey(construction.constructionId());
        return new HintsControllerImpl(selfId, blsKeyPair, construction, weights, this.executor, this.library, votes, publications, this.submissions, this.context, this.configurationSupplier, hintsStore, this.onHintsFinished);
    }

    private long currentConstructionId() {
        return this.controller != null ? this.controller.constructionId() : -1L;
    }
}

