/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.handlers;

import com.hedera.hapi.node.state.history.HistorySignature;
import com.hedera.hapi.services.auxiliary.history.HistoryProofSignatureTransactionBody;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.ProofControllers;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HistoryProofSignatureHandler
implements TransactionHandler {
    private final ProofControllers controllers;

    @Inject
    public HistoryProofSignatureHandler(@NonNull ProofControllers controllers) {
        this.controllers = Objects.requireNonNull(controllers);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        HistoryProofSignatureTransactionBody op = context.body().historyProofSignatureOrThrow();
        long constructionId = op.constructionId();
        this.controllers.getInProgressById(constructionId).ifPresent(controller -> {
            long nodeId = context.creatorInfo().nodeId();
            ReadableHistoryStore.HistorySignaturePublication publication = new ReadableHistoryStore.HistorySignaturePublication(nodeId, op.signatureOrElse(HistorySignature.DEFAULT), context.consensusNow());
            if (controller.addSignaturePublication(publication)) {
                WritableHistoryStore historyStore = (WritableHistoryStore)context.storeFactory().writableStore(WritableHistoryStore.class);
                historyStore.addSignature(constructionId, publication);
            }
        });
    }
}

