/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.handlers;

import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.services.auxiliary.history.HistoryProofVoteTransactionBody;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.ProofControllers;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HistoryProofVoteHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(HistoryProofVoteHandler.class);
    private final ProofControllers controllers;

    @Inject
    public HistoryProofVoteHandler(@NonNull ProofControllers controllers) {
        this.controllers = Objects.requireNonNull(controllers);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(context);
        HistoryProofVoteTransactionBody op = context.body().historyProofVoteOrThrow();
        long constructionId = op.constructionId();
        HistoryProofVote vote = op.voteOrElse(HistoryProofVote.DEFAULT);
        this.controllers.getInProgressById(constructionId).ifPresent(controller -> {
            long nodeId = context.creatorInfo().nodeId();
            WritableHistoryStore historyStore = (WritableHistoryStore)context.storeFactory().writableStore(WritableHistoryStore.class);
            log.info("Received {} from node{} for construction #{}", vote.hasCongruentNodeId() ? "vote congruent to node" + vote.congruentNodeIdOrThrow() : "explicit vote", (Object)context.creatorInfo().nodeId(), (Object)constructionId);
            controller.addProofVote(nodeId, op.voteOrElse(HistoryProofVote.DEFAULT), historyStore);
        });
    }
}

