/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.congestion.CongestionMultipliers;
import com.hedera.node.app.throttle.NetworkUtilizationManager;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.throttle.annotations.BackendThrottle;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NetworkUtilizationManagerImpl
implements NetworkUtilizationManager {
    private final ThrottleAccumulator backendThrottle;
    private final CongestionMultipliers congestionMultipliers;

    @Inject
    public NetworkUtilizationManagerImpl(@BackendThrottle @NonNull ThrottleAccumulator backendThrottle, @NonNull CongestionMultipliers congestionMultipliers) {
        this.backendThrottle = Objects.requireNonNull(backendThrottle, "backendThrottle must not be null");
        this.congestionMultipliers = Objects.requireNonNull(congestionMultipliers, "congestionMultipliers must not be null");
    }

    @Override
    public boolean trackTxn(@NonNull TransactionInfo txnInfo, @NonNull Instant consensusTime, @NonNull State state) {
        boolean shouldThrottle = this.backendThrottle.checkAndEnforceThrottle(txnInfo, consensusTime, state, null);
        this.congestionMultipliers.updateMultiplier(consensusTime);
        return shouldThrottle;
    }

    @Override
    public void trackFeePayments(@NonNull Instant consensusNow, @NonNull State state) {
        TransactionInfo chargingFeesCryptoTransfer = new TransactionInfo(SignedTransaction.DEFAULT, TransactionBody.DEFAULT, TransactionID.DEFAULT, AccountID.DEFAULT, SignatureMap.DEFAULT, Bytes.EMPTY, HederaFunctionality.CRYPTO_TRANSFER, null);
        this.trackTxn(chargingFeesCryptoTransfer, consensusNow, state);
    }

    @Override
    public boolean wasLastTxnGasThrottled() {
        return this.backendThrottle.wasLastTxnGasThrottled();
    }

    @Override
    public void leakUnusedGasPreviouslyReserved(@NonNull TransactionInfo txnInfo, long value) {
        this.backendThrottle.leakUnusedGasPreviouslyReserved(txnInfo, value);
    }

    @Override
    public long availableOpsDurationCapacity(@NonNull Instant consensusTime) {
        return this.backendThrottle.availableOpsDurationCapacity(consensusTime);
    }

    @Override
    public void consumeOpsDurationThrottleCapacity(long opsDurationUnitsToConsume, @NonNull Instant consensusTime) {
        this.backendThrottle.consumeOpsDurationThrottleCapacity(opsDurationUnitsToConsume, consensusTime);
    }

    @Override
    public boolean shouldThrottleNOfUnscaled(int n, @NonNull HederaFunctionality function, @NonNull Instant consensusTime) {
        return this.backendThrottle.shouldThrottleNOfUnscaled(n, function, consensusTime);
    }
}

