/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.congestion.CongestionLevelStarts;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V0490CongestionThrottleSchema
extends Schema {
    private static final Logger log = LogManager.getLogger(V0490CongestionThrottleSchema.class);
    public static final String THROTTLE_USAGE_SNAPSHOTS_KEY = "THROTTLE_USAGE_SNAPSHOTS";
    public static final int THROTTLE_USAGE_SNAPSHOTS_STATE_ID = SingletonType.CONGESTIONTHROTTLESERVICE_I_THROTTLE_USAGE_SNAPSHOTS.protoOrdinal();
    public static final String CONGESTION_LEVEL_STARTS_KEY = "CONGESTION_LEVEL_STARTS";
    public static final int CONGESTION_LEVEL_STARTS_STATE_ID = SingletonType.CONGESTIONTHROTTLESERVICE_I_CONGESTION_LEVEL_STARTS.protoOrdinal();
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();

    public V0490CongestionThrottleSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)THROTTLE_USAGE_SNAPSHOTS_STATE_ID, (String)THROTTLE_USAGE_SNAPSHOTS_KEY, (Codec)ThrottleUsageSnapshots.PROTOBUF), StateDefinition.singleton((int)CONGESTION_LEVEL_STARTS_STATE_ID, (String)CONGESTION_LEVEL_STARTS_KEY, (Codec)CongestionLevelStarts.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        if (ctx.previousVersion() == null) {
            log.info("Creating genesis throttle snapshots and congestion level starts");
            WritableSingletonState throttleSnapshots = ctx.newStates().getSingleton(THROTTLE_USAGE_SNAPSHOTS_STATE_ID);
            throttleSnapshots.put((Object)ThrottleUsageSnapshots.DEFAULT);
            WritableSingletonState congestionLevelStarts = ctx.newStates().getSingleton(CONGESTION_LEVEL_STARTS_STATE_ID);
            congestionLevelStarts.put((Object)CongestionLevelStarts.DEFAULT);
        }
    }
}

