/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.ingest;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.state.DeduplicationCache;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.StatsConfig;
import com.hedera.node.config.types.Profile;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.consensus.transaction.TransactionPoolNexus;

@Singleton
public class SubmissionManager {
    private static final String PLATFORM_TXN_REJECTIONS_NAME = "platformTxnNotCreated_per_sec";
    private static final String PLATFORM_TXN_REJECTIONS_DESC = "number of platform transactions not created per second";
    private static final String SPEEDOMETER_FORMAT = "%,13.2f";
    private static final Bytes MAIN_NET_LEDGER_ID = Bytes.fromHex((String)"00");
    private static final Bytes TEST_NET_LEDGER_ID = Bytes.fromHex((String)"01");
    private static final Bytes PREVIEW_NET_LEDGER_ID = Bytes.fromHex((String)"02");
    private final TransactionPoolNexus transactionPool;
    private final SpeedometerMetric platformTxnRejections;
    private final DeduplicationCache submittedTxns;
    private final ConfigProvider configProvider;

    @Inject
    public SubmissionManager(@NonNull TransactionPoolNexus transactionPool, @NonNull DeduplicationCache deduplicationCache, @NonNull ConfigProvider configProvider, @NonNull Metrics metrics) {
        this.transactionPool = Objects.requireNonNull(transactionPool);
        this.submittedTxns = Objects.requireNonNull(deduplicationCache);
        this.configProvider = Objects.requireNonNull(configProvider);
        StatsConfig statsConfig = (StatsConfig)configProvider.getConfiguration().getConfigData(StatsConfig.class);
        this.platformTxnRejections = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)new SpeedometerMetric.Config("app", PLATFORM_TXN_REJECTIONS_NAME).withDescription(PLATFORM_TXN_REJECTIONS_DESC).withFormat(SPEEDOMETER_FORMAT).withHalfLife(statsConfig.speedometerHalfLifeSecs()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(@NonNull TransactionBody txBody, @NonNull Bytes serializedSignedTx) throws PreCheckException {
        Objects.requireNonNull(txBody);
        Objects.requireNonNull(serializedSignedTx);
        Bytes payload = serializedSignedTx;
        if (txBody.hasUncheckedSubmit()) {
            VersionedConfiguration configuration = this.configProvider.getConfiguration();
            HederaConfig hederaConfig = (HederaConfig)configuration.getConfigData(HederaConfig.class);
            LedgerConfig ledgerConfig = (LedgerConfig)configuration.getConfigData(LedgerConfig.class);
            if (hederaConfig.activeProfile() == Profile.PROD || MAIN_NET_LEDGER_ID.equals((Object)ledgerConfig.id()) || TEST_NET_LEDGER_ID.equals((Object)ledgerConfig.id()) || PREVIEW_NET_LEDGER_ID.equals((Object)ledgerConfig.id())) {
                throw new PreCheckException(ResponseCodeEnum.PLATFORM_TRANSACTION_NOT_CREATED);
            }
            payload = txBody.uncheckedSubmitOrThrow().transactionBytes();
        }
        DeduplicationCache deduplicationCache = this.submittedTxns;
        synchronized (deduplicationCache) {
            TransactionID txId = txBody.transactionIDOrThrow();
            if (this.submittedTxns.contains(txId)) {
                throw new PreCheckException(ResponseCodeEnum.DUPLICATE_TRANSACTION);
            }
            boolean success = this.transactionPool.submitApplicationTransaction(payload);
            if (success) {
                this.submittedTxns.add(txId);
                if (txBody.hasAtomicBatch() && !txBody.atomicBatchOrThrow().transactions().isEmpty()) {
                    List transactions = txBody.atomicBatchOrThrow().transactions();
                    for (Bytes buffer : transactions) {
                        try {
                            SignedTransaction signedTransaction = (SignedTransaction)SignedTransaction.PROTOBUF.parseStrict(buffer.toReadableSequentialData());
                            TransactionBody body = (TransactionBody)TransactionBody.PROTOBUF.parseStrict(signedTransaction.bodyBytes().toReadableSequentialData());
                            TransactionID innerTxnId = body.transactionIDOrThrow();
                            this.submittedTxns.add(innerTxnId);
                        }
                        catch (ParseException e) {
                            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION);
                        }
                    }
                }
            } else {
                this.platformTxnRejections.cycle();
                throw new PreCheckException(ResponseCodeEnum.PLATFORM_TRANSACTION_NOT_CREATED);
            }
        }
    }
}

